@extends('frontend.layout.layout')
@section('meta_tag')
    <title>{{ $blog->meta_title }}</title>
    <meta name="description" content="{{ $blog->meta_description }}">
@endsection
@section('content')
    <div class="breadcrumb-sec">
        <div class="container">
            <ul>
                <li><a href="{{ route('frontend.index') }}">Home</a></li>
                <li><span>/</span></li>
                <li><a href="{{ route('frontend.blogs') }}">Blogs</a></li>
                <li><span>/</span></li>
                <li>Details</li>
            </ul>
        </div>
    </div>

    <div class="blog-details-main">
        <div class="container">
            <div class="card">
                <div class="card-header">
                    <img src="{{ asset($blog->image) }}" alt="" />
                </div>
                <div class="card-body">
                    <h4>{{ $blog->title }}</h4>
                    <p>
                        {!! $blog->description !!}
                    </p>
                    <strong>
                        {{ Carbon\Carbon::parse($blog->date)->format('F d,Y') }}</strong>
                </div>
            </div>
        </div>
    </div>
@endsection
