@extends('frontend.layout.layout')
@section('meta_tag')
    <title>{{ SiteInfo::info()['site_name'] }}</title>
@endsection
@section('content')
    <!---------------- product listing area start -------------->
    @if (!empty($products))
        <section class="product_listing">
            <div class="container">
                <div class="row">
                    <div class="col-md-3">
                        <div class="accordion prdt_accordion" id="accordionExample">
                            @if (!empty($colors))
                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="headingOne">
                                        <i class="fa fa-paint-brush" aria-hidden="true"></i>
                                        <button class="accordion-button" type="button" data-bs-toggle="collapse"
                                            data-bs-target="#collapseOne" aria-expanded="true" aria-controls="collapseOne">
                                            finish color <i class="fa fa-angle-down" aria-hidden="true"></i>
                                        </button>
                                    </h2>
                                    <div id="collapseOne" class="accordion-collapse collapse show"
                                        aria-labelledby="headingOne" data-bs-parent="#accordionExample">
                                        <div class="accordion-body">
                                            <ul>
                                                @foreach ($colors as $color)
                                                    <li>
                                                        <input class="form-check-input mt-0" type="checkbox" value=""
                                                            aria-label="Checkbox for following text input"
                                                            id="color_{{ $color->id }}"
                                                            onclick="getColorFilter({{ $color->id }},'color',this.id)">
                                                        <p class="spanColor"></p>
                                                        <span>{{ $color->name }}</span>
                                                    </li>
                                                @endforeach

                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            @endif
                            <div class="accordion-item">
                                <h2 class="accordion-header" id="headingTwo">
                                    <i class="fa fa-usd" aria-hidden="true"></i>
                                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                        data-bs-target="#collapseTwo" aria-expanded="false" aria-controls="collapseTwo">
                                        price <i class="fa fa-angle-down" aria-hidden="true"></i>
                                    </button>
                                </h2>
                                <div id="collapseTwo" class="accordion-collapse collapse" aria-labelledby="headingTwo"
                                    data-bs-parent="#accordionExample">
                                    <div class="accordion-body">
                                        <ul>
                                            <li>
                                                <input class="form-check-input mt-0" type="radio" name="price"
                                                    value="" aria-label="Checkbox for following text input"
                                                    onclick="getColorFilter(1,'price',null)">
                                                <p class="spanColor"></p>
                                                <span>Price: Low to High</span>
                                            </li>
                                            <li>
                                                <input class="form-check-input mt-0" type="radio" name="price"
                                                    value="" onclick="getColorFilter(2,'price',null)">
                                                <p class="spanColor"></p>
                                                <span>Price: High to Low</span>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-9">
                        <div class="prdtList">
                            <div class="row" id="product_div">
                                @include('frontend.public.cabinate_accessories_pro', [
                                    'products' => $products,
                                ])
                            </div>

                        </div>
                    </div>
                </div>
            </div>
        </section>
    @endif

    <!---------------- product listing area end -------------->
    @push('scripts')
        <script>
            let colorFilter = [];
            let priceFilter;

            function getColorFilter(id, type, div_id) {
                if (type == 'color') {
                    // colorFilter = id;
                    if ($(`#${div_id}`).prop('checked') == true) {
                        colorFilter.push(id);
                    } else {
                        let index = colorFilter.indexOf(id);
                        if (index > -1) { // only splice array when item is found
                            colorFilter.splice(index, 1); // 2nd parameter means remove one item only
                        }
                    }
                }
                if (type == 'price') {
                    priceFilter = id;
                }
                $.ajax({
                    url: "{{ route('frontend.cabinate.accessories.filter') }}",
                    type: "post",
                    data: {
                        _token: '{{ csrf_token() }}',
                        colorFilter: colorFilter,
                        priceFilter: priceFilter
                    },
                    success: function(response) {
                        if (response.status == 'success') {
                            $("#product_div").html(response.html);
                        } else {
                            // $("#price_section").hide();
                            // // $("#cart_section").hide();
                            // $('#cart_section').prop("disabled", true);
                            // toastr.error(response.msg, 'Warning!');
                        }
                        // You will get response from your PHP page (what you echo or print)
                    },
                    error: function(jqXHR, textStatus, errorThrown) {
                        console.log(textStatus, errorThrown);
                    }
                });
            }
        </script>
    @endpush
@endsection
