@extends('frontend.layout.layout')
@section('meta_tag')
    <title>
        {{ SiteInfo::info()['site_name'] }}</title>
@endsection
@section('content')
    <style>
        .lengthUL li.lengthLi {
            border: 2px solid #7e7c79;
        }

        .lengthUL li.lengthLi.selected {
            border: 2px solid #d8a143;
        }

        .post-slide p {
            overflow-y: auto !important;
            height: 100px !important;
        }

        .post-slide ul.listgroup li.line0 {
            display: flex;
            justify-content: center;
        }

        .post-slide ul.listgroup li.line0 img {
            width: 50px;
            height: 50px;
            border-radius: 50%;
        }
    </style>
    @if (!empty($product))
        <section class="productDtls product_listing">
            <div class="container">
                <div class="row">
                    <div class="col-md-5">
                        <div class="productDtlsImg">
                            <img src="{{ asset($product_image->image) }}" alt="" loading="lazy" id="pro_image">
                        </div>
                    </div>
                    <div class="col-md-7">
                        <div class="productDtlsTxt">
                            <h5>{{ $product->name }}</h5>
                            <p id="price_section">
                                @if (!empty($product->main_price))
                                    <small>${{ number_format($product->main_price, 2, '.', '') }}</small>
                                @endif
                                <span> ${{ number_format($product->discount_price, 2, '.', '') }}</span>
                            </p>

                            <div class="topDiscription mb-5">
                                <div class="accordion" id="accordionExample">
                                    @if (!empty($colors))
                                        <div class="accordion-item">
                                            <h2 class="accordion-header" id="headingOne">
                                                <button class="accordion-button" type="button" data-bs-toggle="collapse"
                                                    data-bs-target="#collapseOne" aria-expanded="true"
                                                    aria-controls="collapseOne">
                                                    <span>1</span> finish color
                                                </button>
                                            </h2>
                                            <div id="collapseOne" class="accordion-collapse collapse show"
                                                aria-labelledby="headingOne" data-bs-parent="#accordionExample">
                                                <div class="accordion-body">
                                                    <div class="row">
                                                        @foreach ($colors as $key => $color)
                                                            <div class="col-md-4"
                                                                onclick="getproduct({{ $color->color_id }},'color','{{ asset($color->image) }}')">
                                                                <div class="prdt_color" id="color_{{ $color->color_id }}">
                                                                    <img src="{{ asset($color->image) }}" alt=""
                                                                        loading="lazy">
                                                                    <h6>{{ $color->color->name }}</h6>
                                                                </div>
                                                            </div>
                                                        @endforeach

                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    @endif
                                    @if (count($lengths) > 0)
                                        <div class="accordion-item">
                                            <h2 class="accordion-header" id="headingTwo">
                                                <button class="accordion-button collapsed" type="button"
                                                    data-bs-toggle="collapse" data-bs-target="#collapseTwo"
                                                    aria-expanded="false" aria-controls="collapseTwo">
                                                    <span>2</span> overall length
                                                </button>
                                            </h2>
                                            <div id="collapseTwo" class="accordion-collapse collapse"
                                                aria-labelledby="headingTwo" data-bs-parent="#accordionExample">
                                                <div class="accordion-body">
                                                    <ul class="lengthUL">
                                                        @foreach ($lengths as $key1 => $length)
                                                            <li onclick="getproduct({{ $length->id }},'length',null)"
                                                                class="lengthLi" id="length_{{ $length->id }}">
                                                                {{ $length->name }}</li>
                                                        @endforeach
                                                    </ul>
                                                </div>
                                            </div>
                                        </div>
                                    @endif

                                </div>
                            </div>
                            <div class="mb-2 d-flex justify-content-end">
                                <button id="cart_section" href="javascript:void(0)" disabled
                                    onclick="pushOnCart('{{ $product->id }}')" class="btn btn-success text-white"
                                    style="background: #198754;">Add
                                    to
                                    cart</button>
                            </div>

                            <div class="bottomDiscription">
                                <div class="accordion accordion-flush" id="accordionFlushExample">
                                    <div class="accordion-item">
                                        <h2 class="accordion-header" id="flush-headingOne">
                                            <button class="accordion-button collapsed" type="button"
                                                data-bs-toggle="collapse" data-bs-target="#flush-collapseOne"
                                                aria-expanded="false" aria-controls="flush-collapseOne">
                                                Discription
                                            </button>
                                        </h2>
                                        <div id="flush-collapseOne" class="accordion-collapse collapse"
                                            aria-labelledby="flush-headingOne" data-bs-parent="#accordionFlushExample">
                                            <div class="accordion-body">
                                                {{-- <p> --}}
                                                {!! $product->description !!}
                                                {{-- </p> --}}
                                            </div>
                                        </div>
                                    </div>
                                    <div class="accordion-item">
                                        <h2 class="accordion-header" id="flush-headingTwo">
                                            <button class="accordion-button collapsed" type="button"
                                                data-bs-toggle="collapse" data-bs-target="#flush-collapseTwo"
                                                aria-expanded="false" aria-controls="flush-collapseTwo">
                                                Measurements
                                            </button>
                                        </h2>
                                        <div id="flush-collapseTwo" class="accordion-collapse collapse"
                                            aria-labelledby="flush-headingTwo" data-bs-parent="#accordionFlushExample">
                                            <div class="accordion-body">
                                                <p>
                                                    {{ $product->measurements }}
                                                </p>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="accordion-item">
                                        <h2 class="accordion-header" id="flush-headingThree">
                                            <button class="accordion-button collapsed" type="button"
                                                data-bs-toggle="collapse" data-bs-target="#flush-collapseThree"
                                                aria-expanded="false" aria-controls="flush-collapseThree">
                                                Key Features
                                            </button>
                                        </h2>
                                        <div id="flush-collapseThree" class="accordion-collapse collapse"
                                            aria-labelledby="flush-headingThree" data-bs-parent="#accordionFlushExample">
                                            <div class="accordion-body">
                                                <p>
                                                    {{ $product->key_features }}
                                                </p>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="accordion-item">
                                        <h2 class="accordion-header" id="flush-headingFour">
                                            <button class="accordion-button collapsed" type="button"
                                                data-bs-toggle="collapse" data-bs-target="#flush-collapseFour"
                                                aria-expanded="false" aria-controls="flush-collapseFour">
                                                Return Policies
                                            </button>
                                        </h2>
                                        <div id="flush-collapseFour" class="accordion-collapse collapse"
                                            aria-labelledby="flush-headingFour" data-bs-parent="#accordionFlushExample">
                                            <div class="accordion-body">
                                                <p>
                                                    {{ $product->return_policies }}
                                                </p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    @endif


    <!--------------- review area start --------------->

    @if (!empty($customerReviews) && isset($customerReviews))
        <section class="testimonial-main">
            <div class="container">
                <div class="heading text-center">
                    <div class="sub-headline-area">
                        <span></span>
                        <h3>{{ SiteInfo::title()['title7'] ?? null }}</h3><span></span>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <div id="testimonial-slider" class="testimonial-slider-area owl-carousel">
                                @foreach ($customerReviews as $customerReview)
                                    <div class="post-slide">
                                        <ul class="listgroup">
                                            <li class="line1">
                                                {{ Carbon\Carbon::parse($customerReview->created_at)->diffForHumans() }}
                                            </li>
                                            <li class="line2">{{ $customerReview->name }}</li>
                                            @if ($customerReview->verified == 1)
                                                <li class="line3"><span><i class="fa fa-check-circle"
                                                            aria-hidden="true"></i>
                                                    </span>Verified Buyer
                                                </li>
                                            @else
                                                <li class="line3">&nbsp</li>
                                            @endif
                                        </ul>
                                        <ul class="starmark">
                                            @if (!empty($customerReview->retting))
                                                @for ($i = 1; $i <= $customerReview->retting; $i++)
                                                    <li><i class="fa fa-star" aria-hidden="true"></i></li>
                                                @endfor
                                            @endif
                                            @if (5 - $customerReview->retting != 0)
                                                @for ($i = 1; $i <= 5 - $customerReview->retting; $i++)
                                                    <li><i class="fa fa-star-o" aria-hidden="true"></i></li>
                                                @endfor
                                            @endif
                                        </ul>
                                        {{-- <h3>Great quality material Colors are</h3> --}}
                                        <p>{{ $customerReview->commend }}</p>
                                    </div>
                                @endforeach
                            </div>
                            <div class="btn-area">
                                <ul>
                                    <li><a href="{{ route('frontend.customerReviews') }}" class="btn type1">View All
                                            Reviews</a></li>
                                </ul>
                            </div>

                        </div>
                    </div>
                </div>
            </div>
        </section>
    @endif
    <!--------------- review area end --------------->


    <!----------------- more shopping start ---------------->
    @if (!empty($products))
        <section class="shop_more">
            <div class="container">
                <div class="sub-headline-area">
                    <span></span>
                    <h3>Shop Our Cabinet Accessories</h3>
                    <span></span>
                </div>
                <div class="row">
                    @foreach ($products as $prod)
                        <div class="col-md-4">
                            <div class="product">
                                <div class="img_div">
                                    <img src="{{ asset(SiteInfo::cabinet_image($prod->id)['image'] ?? null) }}"
                                        alt="" loading="lazy">
                                </div>
                                <div class="prdt-txt_div">
                                    <ul>
                                        <li>
                                            <a href="{{ route('frontend.cabinate_accessories_details', $prod->id) }}">
                                                <h4>{{ $prod->name }}</h4>
                                            </a>
                                        </li>
                                        <li>
                                            @if (!empty($prod->main_price))
                                                <span><small>${{ number_format($prod->main_price, 2, '.', '') }}</small></span>
                                            @endif
                                            <h6>${{ number_format($prod->discount_price, 2, '.', '') }}</h6>
                                        </li>
                                    </ul>

                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        </section>
    @endif
    @push('scripts')
        <script>
            let color_id, length_id, combi_id;
            let lengthCount = '{{ $lengthCount }}';
            let isColor = false;
            let islength = false;

            function getproduct(id, type, image) {
                if (type == 'color') {
                    color_id = id;
                    isColor = true;
                    $('.prdt_color').removeClass('selected');
                    $(`#color_${id}`).addClass('selected');
                    $("#pro_image").attr('src', image);
                }
                if (type == 'length') {
                    length_id = id;
                    islength = true;
                    $('.lengthLi').removeClass('selected');
                    $(`#length_${id}`).addClass('selected');
                }
                if (lengthCount == 0) {
                    islength = true;
                }
                if (isColor == true && islength == true) {
                    $.ajax({
                        url: "{{ route('frontend.cabinate.accessories.combination') }}",
                        type: "post",
                        data: {
                            _token: '{{ csrf_token() }}',
                            color_id: color_id,
                            length_id: length_id,
                            product_id: '{{$product->id}}',
                        },
                        success: function(response) {
                            if (response.status == 'success') {
                                let price = response.data.main_price;
                                let discount_price = response.data.discount_price;
                                let payable_price = 0;
                                if (!!discount_price && discount_price > 0) {
                                    $("#price_section").html(
                                        `<small>$${price}</small><span>$${discount_price}</span>`);
                                } else {
                                    $("#price_section").html(`<span>$${price}</span>`);
                                }

                                $("#price_section").show();
                                // $("#cart_section").show();
                                combi_id = response.data.id;
                                $('#cart_section').prop("disabled", false);
                            } else {
                                $("#price_section").hide();
                                // $("#cart_section").hide();
                                $('#cart_section').prop("disabled", true);
                                toastr.error(response.msg, 'Warning!');
                            }
                            // You will get response from your PHP page (what you echo or print)
                        },
                        error: function(jqXHR, textStatus, errorThrown) {
                            console.log(textStatus, errorThrown);
                        }
                    });
                }
            }

            function pushOnCart(combination) {
                console.log(combi_id);

                // $("#loader").show();
                $.ajax({
                    url: "{{ route('frontend.cart') }}",
                    type: "post",
                    data: {
                        _token: '{{ csrf_token() }}',
                        combination,
                        combi_id: combi_id
                    },
                    success: function(response) {
                        if (response.status == 'success') {
                            toastr.success(response.msg, 'Success!');
                            $(`#cart_${combination}`).text('Added cart');
                            $(`#cart_${combination}`).addClass("red-color");
                            $(`#cart_count`).html(`(${response.data.cart_count})`);
                            $(`#cart_count1`).html(`(${response.data.cart_count})`);

                        } else {
                            toastr.error(response.msg, 'Warning!');
                        }
                    },
                    error: function(jqXHR, textStatus, errorThrown) {
                        console.log(textStatus, errorThrown);
                    }
                });
            }
        </script>
    @endpush
@endsection
