@extends('frontend.layout.layout')
@section('meta_tag')
    <title>{{ SiteInfo::info()['site_name'] }}</title>
@endsection
@section('content')
    <!-- ====== Shopping Cart Start ====== -->
    <div class="cart-main-sec margin_top">
        <div class="container py-3">
            <h3>Shopping Cart</h3>
            <div class="row">
                <div class="col-12 col-sm-12 col-md-12 col-lg-8">
                    <!-- single cart item  -->
                    <hr />
                    @if (isset($carts['carts']) && !empty($carts['carts']))
                        @foreach ($carts['carts'] as $cart)
                            <div class="cart-item py-2">
                                <div class="row">
                                    <div class="col-12 col-sm-12 col-md-6 col-lg-6">
                                        <div class="d-flex justify-content-between mb-3">
                                            <img class="cart-image d-block" src="{{ $cart['image'] }}" alt="" />
                                            <div class="mx-3">
                                                @if (isset($cart['name']) && !empty($cart['name']))
                                                    <b>{{ $cart['name'] }}</b> <br>
                                                @endif
                                                @if (isset($cart['product_name']) && !empty($cart['product_name']))
                                                    <b>{{ $cart['product_name'] }}</b> <br>
                                                @endif
                                                @if (isset($cart['length']) && !empty($cart['length']))
                                                    <small>{{ $cart['length'] }}</small><br>
                                                @endif
                                                @if (isset($cart['color']) && !empty($cart['color']))
                                                    <small>{{ $cart['color'] }}</small><br>
                                                @endif
                                                @if (isset($cart['type']) && !empty($cart['type']))
                                                    <small>{{ $cart['type'] }}</small><br>
                                                @endif
                                                @if (isset($cart['dimension']) && !empty($cart['dimension']))
                                                    <small>{{ $cart['dimension'] }}</small><br>
                                                @endif
                                                <h5>${{ $cart['payable_price'] }}</h5><br>
                                                {{-- <small
                                                    class="text-white bg-success px-2 py-1 d-inline-block rounded-3 mt-2">In
                                                    Stock</small> --}}
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-12 col-sm-12 col-md-6 col-lg-6">
                                        <div class="d-flex justify-content-between">
                                            <div>
                                                <select class="form-select" name="updates"
                                                    onchange="manageQuantity('{{ $cart['cart_id'] }}',this.value)">
                                                    <option value="1"
                                                        @if ($cart['quantity'] == 1) selected @endif>1</option>
                                                    <option value="2"@if ($cart['quantity'] == 2) selected @endif>
                                                        2</option>
                                                    <option value="3"@if ($cart['quantity'] == 3) selected @endif>
                                                        3</option>
                                                    <option
                                                        value="4"@if ($cart['quantity'] == 4) selected @endif>
                                                        4</option>
                                                    <option
                                                        value="5"@if ($cart['quantity'] == 5) selected @endif>
                                                        5</option>
                                                    <option
                                                        value="6"@if ($cart['quantity'] == 6) selected @endif>
                                                        6</option>
                                                    <option
                                                        value="7"@if ($cart['quantity'] == 7) selected @endif>
                                                        7</option>
                                                    <option
                                                        value="8"@if ($cart['quantity'] == 8) selected @endif>
                                                        8</option>
                                                    <option
                                                        value="9"@if ($cart['quantity'] == 9) selected @endif>
                                                        9</option>
                                                    <option
                                                        value="10"@if ($cart['quantity'] == 10) selected @endif>10
                                                    </option>

                                                </select>
                                            </div>
                                            <div>
                                                <a href="javascript:void(0)" onclick="removeItem('{{ $cart['cart_id'] }}')"
                                                    class="btn-close" aria-label="Close"></a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!-- ./ single cart item end  -->
                            <!-- single cart item  -->
                            <hr />
                        @endforeach
                    @endif
                    <!-- ./ single cart item end  -->
                </div>
                <div class="col-12 col-sm-12 col-md-8 col-lg-4">
                    <div class="bg-light rounded-3 p-4 sticky-top">
                        <div class="d-flex justify-content-between align-items-center">
                            <a class="btn btn-info w-100" style="color: #fff" data-bs-toggle="modal"
                                data-bs-target="#exampleModal">
                                Apply Coupon
                            </a>
                        </div>
                        <h6 class="mb-4">Order Summary</h6>
                        <div class="d-flex justify-content-between align-items-center">
                            <div>Subtotal</div>
                            <div><strong>${{ $carts['subtotal'] }}</strong></div>
                        </div>
                        <hr />
                        <div class="d-flex justify-content-between align-items-center">
                            <div>Delivery Charge</div>
                            <div><strong>${{ $carts['delivery_charge'] }}</strong></div>
                        </div>
                        <hr />
                        @if (!empty($carts['coupon_type']))
                            @if ($carts['coupon_type'] == 'Amount')
                                <div class="d-flex justify-content-between align-items-center">
                                    <div>Coupon discount</div>
                                    <div><strong>${{ $carts['coupon_discount'] }}</strong></div>
                                </div>
                            @else
                                <div class="d-flex justify-content-between align-items-center">
                                    <div>Coupon discount</div>
                                    <div><strong>{{ $carts['coupon_discount'] }}%</strong></div>
                                </div>
                            @endif
                            <hr />
                        @endif
                        <div class="d-flex justify-content-between align-items-center">
                            <div>Total</div>
                            <div><strong>${{ $carts['total_price'] }}</strong></div>
                        </div>
                        @if (auth()->check() == true)
                            <a href="{{ route('frontend.checkout') }}" class="btn btn-primary w-100 mt-4">Checkout</a>
                        @else
                            <a href="{{ route('frontend.login') }}" class="btn btn-primary w-100 mt-4">Sign in</a>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- ====== Shopping Cart End ====== -->
    {{-- <div class="modal fade" id="exampleModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Modal title</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    ...
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                    <button type="button" class="btn btn-primary">Save changes</button>
                </div>
            </div>
        </div>
    </div> --}}

    <div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Modal title</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form action="{{ route('frontend.coupon_apply') }}" method="POST">
                    @csrf
                    <div class="modal-body">
                        <div class="form-group">
                            <input type="text" name="coupon" placeholder="Enter coupon code" class="form-control">
                            {{-- <select class="form-control select2bs4" name="coupon">
                                <option value="" hidden>Choose coupon</option>
                                @if (count($coupons) != 0)
                                    @foreach ($coupons as $coupon)
                                        <option value="{{ $coupon->id }}"
                                            @if (old('coupon') == $coupon->id) selected @endif>
                                            {{ $coupon->code }}
                                        </option>
                                    @endforeach
                                @endif
                            </select> --}}
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-primary">Save coupon</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection
