@extends('frontend.layout.layout')
@section('meta_tag')
    <title>{{ SiteInfo::info()['site_name'] }}</title>
@endsection
@section('content')
    <div class="checkout-main-sec margin_top">
        <div class="container">

            <form action="{{ route('frontend.order') }}" enctype="multipart/form-data" class="d-flex" method="POST">
                @csrf
                {{--                @include('backend.common.message') --}}
                <div class="shoppingCart">
                    <h1>Shopping Cart</h1>
                    <table class="table">
                        <thead>
                            <tr>
                                <th>Item</th>
                                <th class="price">Price</th>
                                <th>Qty</th>
                                <th class="subtotal">Subtotal</th>
                            </tr>
                        </thead>
                        <tbody>
                            @if (isset($carts['carts']) && !empty($carts['carts']))
                                @foreach ($carts['carts'] as $cart)
                                    <tr>
                                        <td class="imageTitle">
                                            <img src="{{ $cart['image'] }}" alt="">



                                            @if (isset($cart['name']) && !empty($cart['name']))
                                                <b>{{ $cart['name'] }}</b> <br>
                                            @endif
                                            @if (isset($cart['product_name']) && !empty($cart['product_name']))
                                                <b>{{ $cart['product_name'] }}</b> <br>
                                            @endif
                                            @if (isset($cart['length']) && !empty($cart['length']))
                                                <small>{{ $cart['length'] }}</small><br>
                                            @endif
                                            @if (isset($cart['color']) && !empty($cart['color']))
                                                <small>{{ $cart['color'] }}</small><br>
                                            @endif
                                            @if (isset($cart['type']) && !empty($cart['type']))
                                                <small>{{ $cart['type'] }}</small><br>
                                            @endif
                                            @if (isset($cart['dimension']) && !empty($cart['dimension']))
                                                <small>{{ $cart['dimension'] }}</small><br>
                                            @endif
                                        </td>
                                        <td class="price">${{ $cart['main_price'] }}</td>
                                        <td class="qty"><input type="text" value="{{ $cart['quantity'] }}" disabled>
                                        </td>
                                        <td class="subtotal">${{ $cart['payable_price'] }}</td>
                                    </tr>
                                @endforeach
                            @endif
                        </tbody>
                    </table>



                    <div class="giftOptions">

                        <div class="area1">
                            <h3><span class="icon"></span>Contact Information</h3>
                            <div class="row">
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label>Full Name *</label>
                                        <input type="text" placeholder="" name='name' class="form-control">
                                    </div>
                                </div>


                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label>Email *</label>
                                        <input type="email" placeholder=""name='email' class="form-control">
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label>Phone Number *</label>
                                        <input type="text" placeholder=""name='phone_number' class="form-control">
                                    </div>
                                </div>
                            </div>

                        </div>

                        <div class="area1">
                            <h3><span class="icon"></span>Address Information</h3>
                            <div class="row">
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label>Street Address *</label>
                                        <input type="text" placeholder="" name='address' class="form-control">
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label>City *</label>
                                        <input type="text" placeholder="" name='city' class="form-control">
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label>Apartment</label>
                                        <input type="text" placeholder="" name='apartment' class="form-control">
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label>Zip Code *</label>
                                        <input type="text" placeholder="" name='pincode' class="form-control">
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label>Country *</label>
                                        <select name="country" id=""
                                            class="form-control <!--js-example-basic-single-->"
                                            onchange="getStates(this.value)">
                                            <option value="">Select country</option>
                                            @if (!empty($countries))
                                                @foreach ($countries as $country)
                                                    <option value="{{ $country->id }}"
                                                        @if (Auth::user()->country == $country->id) selected @endif>
                                                        {{ $country->name }}</option>
                                                @endforeach
                                            @endif
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group" id="state_div">
                                        <label>State / Province</label>
                                        <select name="state" id="" class="form-control">
                                            <option value="">Select state</option>
                                            @if (!empty($states))
                                                @foreach ($states as $state)
                                                    <option value="{{ $state->id }}"
                                                        @if (Auth::user()->state == $state->id) selected @endif>
                                                        {{ $state->name }}</option>
                                                @endforeach
                                            @endif
                                        </select>
                                    </div>
                                </div>
                            </div>

                        </div>

                    </div>

                    {{-- <div class="giftOptions">
                    <h3>Gift options</h3>
                    <p>Pick a paper of your choice (optional)</p>
                    <label><input type="checkbox"> Gift Receipt</label>
                    <label><input type="checkbox"> Printed card</label>
                </div> --}}

                    {{-- <div class="giftCardsWrapper">
                    <h3>Gift Cards</h3>
                    <div class="giftCards">
                        <input type="text" placeholder="Enter the gift card code">
                        <button>ADD GIFT CARD</button>
                    </div>
                </div>

                <div class="discountCodeWrapper">
                    <h3>Apply Discount Code</h3>
                    <div class="discountCode">
                        <input type="text" placeholder="Enter discount code">
                        <button>APPLY DISCOUNT</button>
                    </div>
                </div> --}}
                </div>

                <div class="orderSummary">
                    <h2>Order Summary</h2>
                    {{-- <div class="shippingOptions">
                    <h3>Estimate Shipping and Tax</h3>
                    <label>Country</label>
                    <select>
                        <option>United States</option>
                    </select>
                    <label>State/Province</label>
                    <select>
                        <option>State/Province</option>
                    </select>
                    <label>Zip/Postal Code</label>
                    <input type="text" placeholder="Zip/Postal Code">
                </div> --}}
                    {{-- <div class="amount_wrapper">
                    <div class="flatRate">
                        <input type="radio" name="shipping" checked> Flat Rate ($5.00)
                    </div>
                    <div class="bestWay">
                        <input type="radio" name="shipping"> Best Way (Table Rate $15.00)
                    </div>
                </div> --}}
                    <div class="totalPrice">
                        <p>Subtotal <span>${{ $carts['subtotal'] }}</span></p>
                        <p>Delivery Charge <span>${{ $carts['delivery_charge'] }}</span></p>
                        @if (!empty($carts['coupon_type']))
                            @if ($carts['coupon_type'] == 'Amount')
                                <p>Coupon discount <span>${{ $carts['coupon_discount'] }}</span></p>
                            @else
                                <p>Coupon discount <span>{{ $carts['coupon_discount'] }}%</span></p>
                            @endif
                        @endif
                        <p class="total">Order Total <span>${{ $carts['total_price'] }}</span></p>
                    </div>
                    {{-- <div class="proceed_section"> --}}
                    <div class="strip-btn">
                        <script src="https://checkout.stripe.com/checkout.js" class="stripe-button"
                            data-key="{{ config('services.stripe.api_key') }}" data-amount="{{ $carts['total_price'] * 100 }}"
                            data-name="Example Payment" data-description="Example payment description"
                            data-image="https://stripe.com/img/documentation/checkout/marketplace.png" data-locale="auto" data-currency="usd">
                        </script>
                    </div>
                    {{-- </div> --}}
                </div>
            </form>
        </div>
    </div>
    @push('scripts')
        <script>
            function getStates(country_id) {
                $.ajax({
                    url: "{{ route('frontend.get_states') }}",
                    type: "post",
                    data: {
                        _token: '{{ csrf_token() }}',
                        country_id: country_id
                    },
                    success: function(response) {
                        if (response.status == 'success') {
                            let html = `<label>State / Province</label>
                                    <select name="state" id="" class="form-control">`;
                            response.data.forEach((element) => {
                                html += `<option value="${element.id}">${element.name}</option>`;
                            });
                            html += `</select>`;
                            $("#state_div").html(html);
                        }
                        // You will get response from your PHP page (what you echo or print)
                    },
                    error: function(jqXHR, textStatus, errorThrown) {
                        console.log(textStatus, errorThrown);
                    }
                });
            }
        </script>
    @endpush
@endsection
