@extends('frontend.layout.layout')
@section('meta_tag')
    <title>{{ SiteInfo::info()['site_name'] }}</title>
@endsection
@section('content')
    <style type="text/css">
        #map_wrapper {

            height: 400px;

        }

        #map_canvas {

            width: 100%;

            height: 100%;

        }

        .info_content {
            color: #000 !important;
        }
    </style>


    <!-- breadcrumb -->
    <div class="breadcrumb-sec">
        <div class="container">
            <ul>
                <li><a href="{{ route('frontend.index') }}">Home</a></li>
                <li><span>/</span></li>
                <li>Contact Us</li>
            </ul>
        </div>
    </div>

    <!-- contact us sec -->

    <div class="contact-section">
        <div class="container">
            <div class="headarea">
                <h2>Contact Us</h2>
            </div>
            <div class="account-main-section">
                <div class="container">
                    <div class="form-area part2">
                        <form action="{{ route('frontend.contact_submit') }}" enctype="multipart/form-data"
                            autocomplete="off" method="POST" id="myForm">
                            @csrf
                            @include('backend.common.message')

                            <div class="area1">
                                <h3><span class="icon"></span>Contact Information</h3>
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label>Full Name *</label>
                                            <input type="text" placeholder="" name='name' class="form-control">
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label>Phone No *</label>
                                            <input type="text" placeholder="" name='phone' class="form-control">
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label>Email *</label>
                                            <input type="email" placeholder="" value="{{old('email')}}" name='email' id='email' class="form-control">
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="btn-area area002">
                                            <button type="button" class="btn" id="verify">Verify
                                                Email</button>
                                        </div>
                                    </div>

                                    <div class="col-md-4">

                                        <div class="form-group">
                                            <input type="number" class="form-control" placeholder="Otp" id="otp"
                                                value="{{ old('otp') }}" name="otp">
                                        </div>
                                    </div>
                                    <div class="col-md-12">
                                        <div class="form-group">
                                            <label>Message *</label>
                                            <textarea name="messages" id="" cols="3" class="form-control" style="height: 80px;"></textarea>
                                        </div>
                                    </div>
                                    <div class="col-md-12">
                                        <div class="form-group">
                                            <label id="captchaQuestion"></label>
                                            <input type="text" id="captchaAnswer" class="form-control"
                                                placeholder="Answer" required />
                                            <small id="captchaError" style="color:red; display:none;">Wrong answer.
                                                Try
                                                again.</small>
                                        </div>
                                    </div>
                                </div>

                            </div>
                            <div class="btn-area area002">
                                <button type="submit" class="btn">Submit</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
            <div class="contact-info">
                <ul>
                    <li>Address 1 :- </li>
                    <li>{{ SiteInfo::info()['address'] }} (Peachtree Corners)</li>
                    {{-- <li>Address 2 :- </li>
                    <li>1000 North point Cir. Alpharetta GA 30022 SUIT 1090 </li> --}}
                    {{-- <li>3400 Rivergreen Ct,</li>
                    <li>Ste 600</li>
                    <li>Duluth, GA 30096</li>
                    <li>P:404.493.5802</li>
                    <li>info@b2bcabinet.com</li> --}}
                </ul>
                {{-- <div class="map-area">
                <div id="map_wrapper">

                    <div id="map_canvas" class="mapping"></div>

                </div>
                </div> --}}

                <div class="map-area">
                    {{-- <div id="mymap"></div> --}}
                    <iframe src="{{ SiteInfo::info()['map'] }}" width="100%" height="450" style="border:0;"
                        allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade"></iframe>
                </div>



                <ul>
                    {{-- <li>Address 1 :- </li>
                    <li>{{ SiteInfo::info()['address'] }}</li> --}}
                    <li>Address 2 :- </li>
                    <li>{{ SiteInfo::info()['address1'] }} (Alpharetta)</li>
                    {{-- <li>3400 Rivergreen Ct,</li>
                    <li>Ste 600</li>
                    <li>Duluth, GA 30096</li>
                    <li>P:404.493.5802</li>
                    <li>info@b2bcabinet.com</li> --}}
                </ul>
                <div class="map-area">
                    <iframe src="{{ SiteInfo::info()['map1'] }}" width="100%" height="450" style="border:0;"
                        allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade"></iframe>
                </div>

            </div>
        </div>
    </div>
    {{-- <div class="account-main-section">
        <div class="container">
            <div class="form-area">
                <form action="{{ route('frontend.contact_submit') }}" method="POST" enctype="multipart/form-data">
                    @csrf
                    @include('backend.common.message')
                    <div class="form-group">
                        <input type="text" class="form-control" placeholder="Full Name" name='name'
                            value="{{ old('name') }}">
                    </div>
                    <div class="form-group">
                        <input type="email" class="form-control" placeholder="Email Id" name='email'
                            value="{{ old('email') }}">
                    </div>
                    <div class="form-group">
                        <input type="number" class="form-control" placeholder="Phone Number" name='phone'
                            value="{{ old('phone') }}">
                    </div>
                    <div class="form-group">
                        <input type="text" class="form-control" placeholder="Subject" name='subject'
                            value="{{ old('subject') }}">
                    </div>
                    <div class="form-group">
                        <textarea class="form-control" rows="4" placeholder="Messages" name='messages'>{{ old('messages') }}</textarea>
                    </div>
                    <div class="btn-area">
                        <button type="submit" class="btn">Submit</button>
                    </div>
                </form>
            </div>
        </div>
    </div> --}}
    @push('scripts')
        <script type="text/javascript">
            /*jQuery(function($) {

                                                                                                                                                <!-- Asynchronously Load the map API  -->

                                                                                                                                                var script = document.createElement('script');

                                                                                                                                                script.src = "http://maps.googleapis.com/maps/api/js?sensor=false&callback=initialize";

                                                                                                                                                document.body.appendChild(script);

                                                                                                                                            });

                                                                                                                                            function initialize() {

                                                                                                                                                var map;

                                                                                                                                                var bounds = new google.maps.LatLngBounds();

                                                                                                                                                var mapOptions = {

                                                                                                                                                    mapTypeId: 'roadmap'

                                                                                                                                                };



                                                                                                                                                <!-- Display a map on the page -->

                                                                                                                                                map = new google.maps.Map(document.getElementById("map_canvas"), mapOptions);

                                                                                                                                                map.setTilt(45);



                                                                                                                                                <!-- Multiple Markers -->

                                                                                                                                                var markers = [

                                                                                                                                                    ['6679 Peachtree Industrial Blvd suite', 33.9398432, -84.2534257, 1],

                                                                                                                                                    ['1000 North Point', 34.0473515, -84.29817, 2]

                                                                                                                                                ];



                                                                                                                                                <!-- Info Window Content -->

                                                                                                                                                var infoWindowContent = [

                                                                                                                                                    ['<div class="info_content" style="color: #000 !important;">' +

                                                                                                                                                    '<h3>6679 Peachtree Industrial Blvd suite</h3>' +

                                                                                                                                                    '</div>'],

                                                                                                                                                    ['<div class="info_content" style="color: #000 !important;">' +

                                                                                                                                                    '<h3>1000 North Point</h3>' +

                                                                                                                                                    '</div>']
                                                                                                                                                ];



                                                                                                                                                <!-- Display multiple markers on a map -->

                                                                                                                                                var infoWindow = new google.maps.InfoWindow(), marker, i;



                                                                                                                                                <!-- Loop through our array of markers & place each one on the map   -->

                                                                                                                                                for( i = 0; i < markers.length; i++ ) {

                                                                                                                                                    var position = new google.maps.LatLng(markers[i][1], markers[i][2]);

                                                                                                                                                    bounds.extend(position);

                                                                                                                                                    marker = new google.maps.Marker({

                                                                                                                                                        position: position,

                                                                                                                                                        map: map,

                                                                                                                                                        title: markers[i][0]

                                                                                                                                                    });



                                                                                                                                                    <!-- Allow each marker to have an info window     -->

                                                                                                                                                    google.maps.event.addListener(marker, 'click', (function(marker, i) {

                                                                                                                                                        return function() {

                                                                                                                                                            infoWindow.setContent(infoWindowContent[i][0]);

                                                                                                                                                            infoWindow.open(map, marker);

                                                                                                                                                        }

                                                                                                                                                    })(marker, i));

                                                                                                                                                    <!-- Automatically center the map fitting all markers on the screen -->

                                                                                                                                                    map.fitBounds(bounds);

                                                                                                                                                }

                                                                                                                                                <!-- Override our map zoom level once our fitBounds function runs (Make sure it only runs once) -->

                                                                                                                                                var boundsListener = google.maps.event.addListener((map), 'bounds_changed', function(event) {

                                                                                                                                                    this.setZoom(10);

                                                                                                                                                    google.maps.event.removeListener(boundsListener);

                                                                                                                                                });



                                                                                                                                            }*/
            // Generate random math question
            const captchaQuestion = document.getElementById("captchaQuestion");
            const captchaInput = document.getElementById("captchaAnswer");
            const captchaError = document.getElementById("captchaError");

            let a = Math.floor(Math.random() * 10) + 1;
            let b = Math.floor(Math.random() * 10) + 1;
            let result = a + b;

            captchaQuestion.textContent = `What is ${a} + ${b}?`;

            document.getElementById("myForm").addEventListener("submit", function(e) {
                e.preventDefault(); // prevent form submission

                if (parseInt(captchaInput.value) === result) {
                    captchaError.style.display = "none";
                    // You can use this line to actually submit:
                    e.target.submit();
                } else {
                    captchaError.style.display = "block";
                }
            });
            $("#verify").click(function(e) {
                var email = document.getElementById("email").value;
                document.getElementById('verify').innerText = 'Otp Sending ...';
                $.ajax({
                    url: "{{ route('frontend.contact_verify') }}",
                    type: "post",
                    data: {
                        _token: '{{ csrf_token() }}',
                        email: email
                    },
                    success: function(response) {
                        document.getElementById('verify').innerText = 'Send OTP';
                        if (response.status == 'success') {
                            toastr.success(response.msg, 'Success!');

                        } else {
                            toastr.error(response.msg, 'Warning!');
                        }
                    },
                    error: function(jqXHR, textStatus, errorThrown) {
                        console.log(textStatus, errorThrown);
                    }
                });

            });
        </script>
    @endpush
@endsection
