@extends('frontend.layout.layout')
@section('meta_tag')
    <title>{{ SiteInfo::info()['site_name'] }}</title>
@endsection
@section('content')
    <style>
        .card p {
            overflow-y: auto !important;
            height: 100px !important;
        }

        .card ul.listgroup li.line0 {
            display: flex;
            justify-content: center;
        }

        .card ul.listgroup li.line0 img {
            width: 50px;
            height: 50px;
            border-radius: 50%;
        }

        .card .starmark {
            display: flex;
            flex-direction: row;
            justify-content: center;
            margin: 5px 0;
        }

        .card .listgroup .line3 {
            font-size: 12px;
        }
    </style>
    <div class="breadcrumb-sec">
        <div class="container">
            <ul>
                <li><a href="{{ route('frontend.index') }}">Home</a></li>
                <li><span>/</span></li>
                <li>Customer Reviews</li>
            </ul>
        </div>
    </div>
    @if (count($customerReviews) > 0)
        <div class="blog-main-sec">
            <div class="container">
                <div class="row">
                    @foreach ($customerReviews as $customerReview)
                        <div class="col-md-6 col-lg-4">
                            <div class="card">
                                <div class="post-slide" style="padding: 16px 20px;">
                                    <ul class="listgroup">
                                        <li class="line0">
                                            <!--<img src="{{ asset($customerReview->image) }}" alt="" />-->
                                        </li>
                                        <li class="line1 text-center">
                                            {{ Carbon\Carbon::parse($customerReview->created_at)->diffForHumans() }}
                                        </li>
                                        <li class="line2 text-center">{{ $customerReview->name }}</li>
                                        @if ($customerReview->verified == 1)
                                            <li class="line3 text-center">
                                                <span>
                                                    <i class="fa fa-check-circle" aria-hidden="true"
                                                        style="color: #0fa738;"></i>
                                                </span>
                                                Verified Buyer
                                            </li>
                                        @endif
                                    </ul>
                                    <ul class="starmark">

                                        @if (!empty($customerReview->retting))
                                            @for ($i = 1; $i <= $customerReview->retting; $i++)
                                                <li><i class="fa fa-star" style="color: #bc7c10;" aria-hidden="true"></i>
                                                </li>
                                            @endfor
                                        @endif
                                        @if (5 - $customerReview->retting != 0)
                                            @for ($i = 1; $i <= 5 - $customerReview->retting; $i++)
                                                <li><i class="fa fa-star-o" aria-hidden="true"></i></li>
                                            @endfor
                                        @endif
                                    </ul>
                                    {{--                                            <span style="color: #000">{{ $customerReview->position }}</span> --}}
                                    <p>{{ $customerReview->commend }}</p>
                                </div>

                            </div>
                        </div>
                    @endforeach
                    <div class="col-md-12 d-flex justify-content-center">
                        {!! $customerReviews->withQueryString()->links('pagination::bootstrap-4') !!}
                    </div>
                </div>
            </div>
        </div>
    @endif
@endsection
