@extends('frontend.layout.layout')
@section('meta_tag')
    <title>{{ SiteInfo::info()['site_name'] }}</title>
@endsection
@section('content')
    <div class="breadcrumb-sec">
        <div class="container">
            <ul>
                <li><a href="index.html">Home</a></li>
                <li><span>/</span></li>
                <li>Free Design Help</li>
            </ul>
        </div>
    </div>
    <!-- ====== Free design help page Start ====== -->
    <div class="design-help-sec">
        <div class="section-1">
            <div class="container">
                <div class="row">
                    <div class="col-md-6">
                        <div class="design-help-info">
                            <h3>{{ $FreeDesignContent->title_one ?? null }}</h3>
                            <form action="{{ route('frontend.design_help_submit') }}" class="form-area" method="POST"
                                enctype="multipart/form-data" id="myForm" autocomplete="off">
                                @csrf
                                @include('backend.common.message')

                                <div class="form-group">
                                    <input type="text" class="form-control" name='name' placeholder="Full Name*">
                                </div>
                                <div class="form-group">
                                    <input type="email" class="form-control" name='email' placeholder="Email*">
                                </div>
                                <div class="form-group">
                                    <input type="number" class="form-control" name='phone' placeholder="Phone*">
                                </div>
                                <div class="form-group">
                                    <div class="g-recaptcha"
                                        data-sitekey="{{ config('services.recaptcha.site_key') }}">
                                    </div>
                                </div>
                                <button type="submit" class="btn">Get Started</button>
                            </form>
                            <p>{!! $FreeDesignContent->description_one ?? null !!}
                            </p>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="image-area">
                            <img src="{{ asset($FreeDesignContent->image ?? null) }}" alt="">
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="section-2">
            <div class="container">
                <div class="headline-1">
                    <h3>{{ $FreeDesignContent->title_two ?? null }}</h3>
                </div>
                <div class="row">
                    <div class="col-md-6">
                        <div class="infoarea-1">
                            <h2>1</h2>
                            <h3>{{ $FreeDesignContent->title_three ?? null }}</h3>
                            <p>
                                {{ $FreeDesignContent->description_two ?? null }}
                            </p>
                           <!-- <a href="{{ $FreeDesignContent->button_url_one ?? null }}" class="btn">Submit Now</a>-->
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="infoarea-1">
                            <h2>2</h2>
                            <h3>{{ $FreeDesignContent->title_four ?? null }}</h3>
                            <p>
                                {{ $FreeDesignContent->description_three ?? null }}
                            </p>
                            <!--<a href="{{ $FreeDesignContent->button_url_two ?? null }}" class="btn">Get Started-->
                            <!--</a>-->
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="section-3">
            <div class="container">
                <div class="headline-1">
                    <h3 style="color: black;">{{ $FreeDesignContent->title_five ?? null }}</h3>
                </div>
            </div>
            @if (!empty($FreeDesignServices))
                @foreach ($FreeDesignServices as $key => $FreeDesignService)
                    @if ((int) $key % 2 == 0)
                        <div class="part-1">
                            <div class="container">
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="img-area">
                                            <img src="{{ asset($FreeDesignService->image) ?? null }}" alt="">
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="info">
                                            @php($count = $key)
                                            <h3>{{ ++$count }}. {{ $FreeDesignService->title ?? null }}</h3>
                                            <p>{{ $FreeDesignService->description ?? null }}</p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    @else
                        <div class="part-1 part-2">
                            <div class="container">
                                <div class="row">

                                    <div class="col-md-6">
                                        <div class="info">
                                            @php($count = $key)
                                            <h3>{{ ++$count }}. {{ $FreeDesignService->title ?? null }}</h3>
                                            <p>{{ $FreeDesignService->description ?? null }}</p>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="img-area">
                                            <img src="{{ asset($FreeDesignService->image) ?? null }}" alt="">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endif
                @endforeach
            @endif
        </div>
    </div>
@endsection
