@extends('frontend.layout.layout')
@section('meta_tag')
    <title>{{ SiteInfo::info()['site_name'] }}</title>
@endsection
@section('content')
    <div class="breadcrumb-sec">
        <div class="container">
            <ul>
                <li><a href="{{ route('frontend.index') }}">Home</a></li>
                <li><span>/</span></li>
                <li>FAQ</li>
            </ul>
        </div>
    </div>

    <section class="faq-main-sec">
        <div class="overlay py-4">
            <div class="container">
                <div class="d-flex flex-column flex-md-row gap-3 justify-content-between align-items-start">
                    {{-- <div class="col-md-4 col-lg-5 col-md-5 sticky-top py-4 px-4 px-md-0 bg-white-gradient">
                        <h1 class="mb-3 fw-bold">Frequently Asked Questions</h1>
                        <div class="mb-2 d-none d-md-block">
                            Here are some of the most common questions we receive about backlink outreach:
                        </div>
                        <button class="btn btn-primary rounded-pill px-4">
                            Hire Us Today! <i class="fa fa-angle-right"></i>
                        </button>
                    </div> --}}
                    <div class="col px-4 py-3">
                        <div class="accordion" id="accordionExample">
                            @foreach ($faqs as $key => $faq)
                                @if ($key == 0)
                                    <div class="accordion-item">
                                        <h2 class="accordion-header" id="headingOne">
                                            <button class="accordion-button" type="button" data-bs-toggle="collapse"
                                                data-bs-target="#collapseOne" aria-expanded="true"
                                                aria-controls="collapseOne">
                                                {{ $faq->title }}
                                            </button>
                                        </h2>
                                        <div id="collapseOne" class="accordion-collapse collapse show"
                                            aria-labelledby="headingOne" data-bs-parent="#accordionExample">
                                            <div class="accordion-body">
                                                {{ $faq->description }}
                                            </div>
                                        </div>
                                    </div>
                                @else
                                    <div class="accordion-item">
                                        <h2 class="accordion-header" id="heading-{{ $key }}">
                                            <button class="accordion-button collapsed" type="button"
                                                data-bs-toggle="collapse" data-bs-target="#collapse-{{ $key }}"
                                                aria-expanded="false" aria-controls="collapse-{{ $key }}">
                                                {{ $faq->title }}
                                            </button>
                                        </h2>
                                        <div id="collapse-{{ $key }}" class="accordion-collapse collapse"
                                            aria-labelledby="heading-{{ $key }}"
                                            data-bs-parent="#accordionExample">
                                            <div class="accordion-body">
                                                {{ $faq->description }}
                                            </div>
                                        </div>
                                    </div>
                                @endif
                            @endforeach
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection
