@extends('frontend.layout.layout')
@section('meta_tag')
    <title>{{ SiteInfo::info()['site_name'] }}</title>
@endsection
@push('css')
    <link href="{{ asset('frontend/css/magnific-popup.min.css') }}" rel="stylesheet">
@endpush
@section('content')
    <!-- inner_banner -->
    <div class="breadcrumb-sec">
        <div class="container">
            <ul>
                <li><a href="{{ route('frontend.index') }}">Home</a></li>
                <li><span>/</span></li>
                <li>Galleries</li>
                <li><span>/</span></li>
                <li>{{ $type->name }}</li>
            </ul>
        </div>
    </div>

    <!-- Gallery -->
    @if (!empty($Galleries))
        <section class=" blog-main-sec">

            <div class="container">
                <div class="row">
                    @foreach ($Galleries as $Gallery)
                        <div class="col-md-3 mb-3">
                            <a class="test-popup-link" href="{{ asset($Gallery->image) }}">
                                <img src="{{ asset($Gallery->image) }}" alt="" loading="lazy"
                                    style="
    height: 150px;">
                            </a>
                        </div>
                    @endforeach
                </div>
            </div>
        </section>
    @endif
@endsection
@push('scripts')
    <script src="{{ asset('frontend/js/jquery.magnific-popup.min.js') }}"></script>
    <script>
        $('.test-popup-link').magnificPopup({
            type: 'image'
            // other options
        });
    </script>
@endpush
