@php
    $carts = Carts::list();
@endphp
<div class="card">
    <div class="card-header" id="headingOne">
        <h2 class="mb-0">
            <button class="btn btn-cart" type="button" data-toggle="collapse" data-target="#collapseOne"
                aria-expanded="true" aria-controls="collapseOne">
                Shopping Cart <span>
                    <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 48 48">
                        <path fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round"
                            stroke-width="4" d="m13 30l12-12l12 12"></path>
                    </svg>
                </span>
            </button>
            <p>
                {{ $carts['cart_count'] }}
                Items's →
                <span>
                    ${{ $carts['subtotal'] }}
                </span>
            </p>
        </h2>
    </div>

    <div id="collapseOne" class="collapse " aria-labelledby="headingOne" data-parent="#accordionExample">
        <div class="card-body">
            @if ($carts['cart_count'] > 0)
                <div class="btns">
                    <button class="btn-01" onclick="removeAllItems()">Clear all</button>
                    <a class="btn-01 colors" href="{{ route('frontend.checkout') }}">Visit cart</a>
                </div>
            @endif
            <div class="row">
                <div class="col-md-12">
                    <div class="my-table">
                        <div class="table-responsive">
                            <table class="table">
                                <thead class="thead-dark">
                                    <tr>
                                        <th scope="col">Product</th>
                                        <th scope="col" class="description">Description</th>
                                        <th scope="col">Price</th>
                                        <th scope="col">Quantity</th>
                                        <th scope="col">Total</th>
                                        <th scope="col">Remove</th>
                                    </tr>
                                </thead>
                                <tbody class="my-tbody">
                                    @if (isset($carts['carts']) && !empty($carts['carts']))
                                        @foreach ($carts['carts'] as $cart)
                                            <tr>
                                                <th scope="row" class="wishlist-pro-img" style="border: none;">
                                                    <a
                                                        href="{{ route('frontend.product_details', ['id' => $cart['product_id']]) }}">
                                                        <img src="{{ $cart['image'] }}" alt="" loading="lazy">
                                                    </a>
                                                </th>
                                                <td class="my-description">
                                                    <div class="description">
                                                        <h4>{{ $cart['name'] }}</h4>
                                                        <p>{{ $cart['color'] }},{{ $cart['tag'] }}</p>
                                                    </div>
                                                </td>
                                                <td>
                                                    <h5>${{ $cart['main_price'] }}</h5>
                                                </td>
                                                <td class="my-quantity">
                                                    <div class="product-quantity">
                                                        <input type="number" value="{{ $cart['quantity'] }}"
                                                            name="updates"
                                                            onkeyup="manageQuantity('{{ $cart['cart_id'] }}',this.value)"
                                                            onchange="manageQuantity('{{ $cart['cart_id'] }}',this.value)">
                                                    </div>
                                                </td>
                                                <td>
                                                    <h5>${{ $cart['payable_price'] }}</h5>
                                                </td>
                                                <td><a href="javascript:void(0)" class="cut"
                                                        onclick="removeItem('{{ $cart['cart_id'] }}')"><svg
                                                            xmlns="http://www.w3.org/2000/svg" width="40"
                                                            height="40" viewBox="0 0 40 40" fill="none">
                                                            <path
                                                                d="M14.1064 25.8917L25.8931 14.1084M14.1064 14.1084L25.8931 25.8917"
                                                                stroke="#1B1B1B" stroke-width="1.5"
                                                                stroke-linecap="round">
                                                            </path>
                                                        </svg></a></td>
                                            </tr>
                                        @endforeach
                                    @endif
                                </tbody>
                            </table>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>
