@extends('frontend.layout.layout')
@section('meta_tag')
    <title>{{ $seo->meta_title }}</title>
    <meta name="description" content="{{ $seo->meta_description }}">
    <meta name="keywords" content="{{ $seo->meta_keywords }}">
    <meta name="google-site-verification" content="VEx4hsAhpA2GcbpBysHl6r96KnSvV6cpiF366YeIQOQ"/>
@endsection
@section('content')
    <!-- banner -->
    @if (!empty($banners))
        <div class="main-slider-section">
            <div id="carouselExampleIndicators" class="carousel slide carousel-fade" data-bs-ride="carousel">
                <div class="carousel-inner">
                    @foreach ($banners as $key => $banner)
                        <div class="carousel-item @if ($key == 0) active @endif">
                            <img src="{{ asset($banner->image) }}" class="d-block w-100" alt="banner-{{ $key }}"
                                 width="1920"
                                 height="600"
                                 fetchpriority="high"
                                 decoding="async">
                            <div class="banner-info">
                                <div class="container">
                                    @if (!empty($banner->title1))
                                        <h2 @if (!empty($banner->color)) @if($banner->color == 'white') class="text-white"
                                            @else class="text-black" @endif @endif>
                                            {{ $banner->title1 ?? null }}</h2>
                                    @endif
                                    @if (!empty($banner->title2))
                                        @if ($key == 0)
                                            <h1
                                                @if (!empty($banner->color)) @if($banner->color == 'white') class="text-white"
                                                @else class="text-black" @endif @endif>
                                                {{ $banner->title2 ?? null }}</h1>
                                        @else
                                            <p
                                                @if (!empty($banner->color)) @if($banner->color == 'white') class="banner-title-2 text-white"
                                                @else class="banner-title-2 text-black" @endif @endif>
                                                {{ $banner->title2 ?? null }}</p>
                                        @endif
                                    @endif
                                    @if (!empty($banner->title3))
                                        <h3 @if (!empty($banner->color)) @if($banner->color == 'white') class="text-white"
                                            @else class="text-black" @endif @endif>
                                            {{ $banner->title3 ?? null }}</h3>
                                    @endif
                                    <ul class="shortline">
                                        @if (!empty($banner->title4))
                                            <li
                                                @if (!empty($banner->color)) @if($banner->color == 'white') class="text-white"
                                                @else class="text-black" @endif @endif>
                                                <span><i class="fa fa-check"
                                                         aria-hidden="true"></i></span>{{ $banner->title4 ?? null }}
                                            </li>
                                        @endif
                                        @if (!empty($banner->title5))
                                            <li
                                                @if (!empty($banner->color)) @if($banner->color == 'white') class="text-white"
                                                @else class="text-black" @endif @endif>
                                                <span><i class="fa fa-check"
                                                         aria-hidden="true"></i></span>{{ $banner->title5 ?? null }}
                                            </li>
                                        @endif
                                        @if (!empty($banner->title6))
                                            <li
                                                @if (!empty($banner->color)) @if($banner->color == 'white') class="text-white"
                                                @else class="text-black" @endif @endif>
                                                <span><i class="fa fa-check"
                                                         aria-hidden="true"></i></span>{{ $banner->title6 ?? null }}
                                            </li>
                                        @endif
                                        @if (!empty($banner->title7))
                                            <li
                                                @if (!empty($banner->color)) @if($banner->color == 'white') class="text-white"
                                                @else class="text-black" @endif @endif>
                                                <span><i class="fa fa-check"
                                                         aria-hidden="true"></i></span>{{ $banner->title7 ?? null }}
                                            </li>
                                        @endif
                                    </ul>
                                    <!--<div class="btn-area">
                                                                                                                                                                                                                                                                                                                                                                                                                                <ul>
                                                                                                                                                                                                                                                                                                                                                                                                                                    <li><a href="#" class="btn type1">Explore Cabinets</a></li>
                                                                                                                                                                                                                                                                                                                                                                                                                                    <li><a href="#" class="btn type2">Get FREE Design & Quote</a></li>
                                                                                                                                                                                                                                                                                                                                                                                                                                </ul>
                                                                                                                                                                                                                                                                                                                                                                                                                            </div>-->
                                </div>
                            </div>
                        </div>
                    @endforeach
                    {{-- <div class="carousel-item">
                        <img src="./assets/images/b-1.jpg" class="d-block w-100" alt="banner-2">
                        <div class="banner-info">
                            <div class="container">
                                <h2>October Cabinet Sale - up to 60% Off</h2>
                                <h1>Quality RTA Cabinets 2</h1>
                                <h3>Fast. Affordable. Stylish.</h3>
                                <ul class="shortline">
                                    <li><span><i class="fa fa-check" aria-hidden="true"></i></span>3-Day Quick Ship
                                        Guarantee</li>
                                    <li><span><i class="fa fa-check" aria-hidden="true"></i></span>0% APR 12 Month Financing
                                    </li>
                                    <li><span><i class="fa fa-check" aria-hidden="true"></i></span>FREE Kitchen Design
                                        Services</li>
                                </ul>
                                <div class="btn-area">
                                    <ul>
                                        <li><a href="#" class="btn type1">Explore Cabinets</a></li>
                                        <li><a href="#" class="btn type2">Get FREE Design & Quote</a></li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="carousel-item">
                        <img src="./assets/images/b-1.jpg" class="d-block w-100" alt="banner-3">
                        <div class="banner-info">
                            <div class="container">
                                <h2>October Cabinet Sale - up to 60% Off</h2>
                                <h1>Quality RTA Cabinets 3</h1>
                                <h3>Fast. Affordable. Stylish.</h3>
                                <ul class="shortline">
                                    <li><span><i class="fa fa-check" aria-hidden="true"></i></span>3-Day Quick Ship
                                        Guarantee</li>
                                    <li><span><i class="fa fa-check" aria-hidden="true"></i></span>0% APR 12 Month Financing
                                    </li>
                                    <li><span><i class="fa fa-check" aria-hidden="true"></i></span>FREE Kitchen Design
                                        Services</li>
                                </ul>
                                <div class="btn-area">
                                    <ul>
                                        <li><a href="#" class="btn type1">Explore Cabinets</a></li>
                                        <li><a href="#" class="btn type2">Get FREE Design & Quote</a></li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div> --}}
                </div>
                <div class="carousel-indicators">

                    @foreach ($banners as $key1 => $banner)
                        <button type="button" data-bs-target="#carouselExampleIndicators"
                                data-bs-slide-to="{{ $key1 }}" class="@if ($key1 == 0) active @endif"
                                aria-current="true" aria-label="Slide {{ $key1++ }}"></button>
                    @endforeach
                </div>
                <button class="carousel-control-prev" type="button" data-bs-target="#carouselExampleIndicators"
                        data-bs-slide="prev">
                    <span class="carousel-control-prev-icon" aria-hidden="true"></span>
                    <span class="visually-hidden">Previous</span>
                </button>
                <button class="carousel-control-next" type="button" data-bs-target="#carouselExampleIndicators"
                        data-bs-slide="next">
                    <span class="carousel-control-next-icon" aria-hidden="true"></span>
                    <span class="visually-hidden">Next</span>
                </button>
            </div>
        </div>
    @endif
    <!-- explore area -->
    <div class="explore-section">
        <div class="container">
            <div class="explore-area">
                <div class="row">
                    <div class="col-md-6">
                        <div class="area01">
                            <ul>
                                <li><span><i data-feather="check"></i></span>3-Day Quick Ship Guarantee®</li>
                                <li><span><i data-feather="check"></i></span>0% APR 12 Month Financing</li>
                                <li><span><i data-feather="check"></i></span>FREE Kitchen Design Services</li>
                            </ul>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="area02">
                            <ul>
                                <li><span>Days</span>2</li>
                                <li><span>Hours</span>10</li>
                                <li><span>Minutes</span>36</li>
                                <li><span>Seconds</span>55</li>
                            </ul>
                        </div>
                    </div>
                </div>


            </div>
        </div>
    </div>
    @if (!empty($customerReviews) && isset($customerReviews))
        <section class="testimonial-main">
            <div class="container">
                <div class="heading text-center">

                    {{-- <div class="sub-headline-area">
                        <span></span>
                        <h3>{{ SiteInfo::title()['title7'] ?? null }}</h3><span></span>
                    </div> --}}
                    <div class="row">
                        <div class="col-md-4">
                            <p><b><img
                                        src="{{ asset('g1.webp') }}"> reviews</b>
                                ({{ $customerReviewCount }})</p>
                        </div>
                        <div class="col-md-4">
                            <div class="sub-headline-area">
                                <span class="d-none d-sm-block"></span>
                                <h3>{{ SiteInfo::title()['title7'] ?? null }}</h3>
                                <span class="d-none d-sm-block"></span>
                            </div>
                        </div>
                        <div class="col-md-4"></div>
                    </div>

                    {{-- <p style="
                    color: black;
                    text-align: justify;"><b>Google reviews</b> :
                                                    {{ $customerReviewCount }}</p> --}}


                    <div class="row">
                        <div class="col-md-12">
                            <div id="testimonial-slider" class="testimonial-slider-area owl-carousel">
                                @foreach ($customerReviews as $customerReview)
                                    <div class="post-slide">
                                        <ul class="listgroup">

                                            <li class="line0">
                                                <!--<img src="{{ asset($customerReview->image) }}" alt="">-->
                                            </li>

                                            <li class="line1">
                                                {{ Carbon\Carbon::parse($customerReview->created_at)->diffForHumans() }}
                                            </li>
                                            <li class="line2">{{ $customerReview->name }}</li>
                                            @if ($customerReview->verified == 1)
                                                <li class="line3"><span><i class="fa fa-check-circle"
                                                                           aria-hidden="true"></i>
                                                    </span>Verified Buyer
                                                </li>
                                            @endif
                                        </ul>
                                        <ul class="starmark">

                                            @if (!empty($customerReview->retting))
                                                @for ($i = 1; $i <= $customerReview->retting; $i++)
                                                    <li><i class="fa fa-star" aria-hidden="true"></i></li>
                                                @endfor
                                            @endif
                                            @if (5 - $customerReview->retting != 0)
                                                @for ($i = 1; $i <= 5 - $customerReview->retting; $i++)
                                                    <li><i class="fa fa-star-o" aria-hidden="true"></i></li>
                                                @endfor
                                            @endif
                                        </ul>
                                        {{--                                        <h3>{{ $customerReview->position }}</h3> --}}
                                        <p>{{ $customerReview->commend }}</p>
                                    </div>
                                @endforeach
                            </div>
                            <div class="btn-area">
                                <ul class="d-flex justify-content-between">
                                    <li>
                                        <a href="{{ SiteInfo::info()['google_review_norcross'] }}" class="btn type1"
                                           target="_blank">
                                            <img src="{{ asset('g1.webp') }}">
                                            Write review for Norcross
                                        </a>
                                    </li>
                                    <li><a href="{{ route('frontend.customerReviews') }}" class="btn type1">View All
                                            Reviews</a></li>
                                    <li>
                                        <a href="{{ SiteInfo::info()['google_review_alpharetta'] }}" class="btn type1"
                                           target="_blank">
                                            <img src="{{ asset('g1.webp') }}">
                                            Write review for Alpharetta
                                        </a>
                                    </li>
                                </ul>
                            </div>

                        </div>
                    </div>
                </div>
            </div>
        </section>
    @endif
    <!--------- our services area -------->
    @if (!empty($ourServisesMasters) && isset($ourServisesMasters))
        <section class="testimonial-main our-service-main">
            <div class="container">
                <div class="heading text-center">
                    <div class="sub-headline-area">
                        <span></span>
                        <h3>Our Services</h3>
                        <span></span>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <div id="services-slider" class="testimonial-slider-area service_sliderDiv owl-carousel">
                                @foreach ($ourServisesMasters as $ourServisesMaster)
                                    <div class="item">
                                        <div class="service_slide">
                                            <div class="service_img">
                                                <img src="{{ asset($ourServisesMaster->image1) }}"
                                                     alt="{{ $ourServisesMaster->name }}" loading="lazy">
                                            </div>
                                            <div class="service_txt">
                                                <div class="row">
                                                    <div class="col-3">
                                                        <div class="service_txt_img">
                                                            <img src="{{ asset($ourServisesMaster->image2) }}"
                                                                 alt="{{ $ourServisesMaster->name }}" loading="lazy">
                                                        </div>
                                                    </div>
                                                    <div class="col-9">
                                                        <a
                                                            href="{{ route('frontend.service', $ourServisesMaster->slug) }}">{{ $ourServisesMaster->name }}</a>
                                                        <p>{{ $ourServisesMaster->title }}
                                                        </p>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                @endforeach
                            </div>
                            {{--<div class="btn-area">
                                <ul>
                                    <li><a href="#" class="btn type1">View All Reviews</a></li>
                                </ul>
                            </div>--}}
                        </div>
                    </div>
                </div>
            </div>
        </section>
    @endif

    <!-- -view product section -->
    @if (!empty($assemblyInstruction))
        <div class="view-product-section">
            <div class="container">
                <div class="row">
                    <div class="col-md-6 col-lg-8">
                        <div class="image-area-01">
                            <img src="{{ asset($assemblyInstruction->image2) }}" alt="Assembly Instruction Image 2">
                            <div class="stickerlogo">
                                <img src="{{ asset($assemblyInstruction->image1) }}" alt="Assembly Instruction Image 1">
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6 col-lg-4">
                        <div class="image-area-02">
                            <img src="{{ asset($assemblyInstruction->image3) }}" alt="Assembly Instruction Image 3">
                        </div>
                        <div class="info">
                            <a href="{{ $assemblyInstruction->video }}" target="_blank">
                                <h3>{{ $assemblyInstruction->title }}</h3>
                                <h4>{{ $assemblyInstruction->shot_description }}<br></h4>
                                <p>Learn More</p>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    @endif

    <!-- Blog -->
    @if (!empty($stores))
        <div class="news-slider-main">
            <div class="container">
                <div class="sub-headline-area2">
                    <h4>{{ SiteInfo::title()['title8'] ?? null }}</h4>
                </div>
                <div id="news-slider" class="news-slider-area owl-carousel">
                    @foreach ($stores as $store)
                        <div class="post-slide">
                            <a href="#">
                                <div class="post-img">
                                    <img src="{{ asset($store->image) }}" alt="{{ $store->title }}">
                                </div>
                            </a>
                            <div class="post-content">
                                <p class="post-description">{{ $store->title }}</p>
                            </div>
                        </div>
                    @endforeach


                </div>
                {{-- <div class="btn-area">
                    <a href="#" class="btn type1">Get Inspired</a>
                </div> --}}
            </div>
        </div>
    @endif
    {{-- @if (!empty($categories))
        <div class="step-category-section">
            <div class="container">
                <div class="sub-headline-area">
                    <span></span>
                    <h3>{{ SiteInfo::title()['title9'] ?? null }}</h3><span></span>
                </div>
                <div class="row">
                    @foreach ($categories as $category)
                        <div class="col-md-4">
                            <div class="item-box">
                                <div class="image-area">
                                    <a href='{{ route('frontend.gallery', $category->id) }}'> <img
                                            src="{{ asset($category->image) }}" alt=""></a>
                                </div>
                                <div class="info">
                                    <h3>{{ $category->name }}</h3>
                                    <!--<div class="btn-area">
                                                                                            <a href="{{ $category->link }}">{{ $category->link_name }}</a>
                                                                                        </div>-->
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        </div>
    @endif --}}

    <!--------- gallery area -------->
    @if (!empty($ourServisesMasters) || isset($categories))
        <section class="testimonial-main gallery-area-main">
            <div class="container">
                <div class="heading text-center">
                    <div class="sub-headline-area">
                        <span></span>
                        <h3>{{ SiteInfo::title()['title9'] ?? null }}</h3>
                        <span></span>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <div id="gallery-slider" class="testimonial-slider-area service_sliderDiv owl-carousel">
                                @foreach ($categories as $category)
                                    <div class="item">
                                        <div class="service_slide">
                                            <div class="service_img">
                                                <img src="{{ asset($category->image) }}" alt="{{ $category->name }}"
                                                     loading="lazy">
                                            </div>
                                            <div class="gallert_txt">
                                                <a
                                                    href='{{ route('frontend.gallery', ['id' => $category->id, 'type' => 1]) }}'>{{ $category->name }}</a>
                                            </div>
                                        </div>
                                    </div>
                                @endforeach
                                @foreach ($ourServisesMasters as $ourServisesMaster)
                                    <div class="item">
                                        <div class="service_slide">
                                            <div class="service_img">
                                                <img src="{{ asset($ourServisesMaster->image1) }}"
                                                     alt="{{ $ourServisesMaster->name }}" loading="lazy">
                                            </div>
                                            <div class="gallert_txt">
                                                <a
                                                    href="{{ route('frontend.gallery', ['id' => $ourServisesMaster, 'type' => 2]) }}">{{ $ourServisesMaster->name }}</a>

                                            </div>
                                        </div>
                                    </div>
                                @endforeach

                            </div>
                        </div>
                    </div>
                </div>
            </div>

        </section>
    @endif

    <!-- contact us sec -->
    <div class="contact-section">
        <div class="container">
            <div class="sub-headline-area mb-0">
                <span></span>
                <h3>GET YOUR QUOTE</h3>
                <span></span>
            </div>
            <div class="account-main-section pt-0">
                <div class="container">
                    <div class="form-area part2 m-0" id="form-section">
                        <form action="{{ route('frontend.quote_submit') }}" enctype="multipart/form-data"
                              autocomplete="off" method="POST" id="myForm">
                            @csrf
                            @include('backend.common.message')

                            <div class="area1">
                                <h3><span class="icon"></span>QUOTE</h3>
                                <div class="row form-start">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <input type="text" class="form-control" placeholder="Full Name"
                                                   id="name" value="{{ old('name') }}" name='name'>
                                        </div>
                                    </div>
                                    <div class="col-md-6">

                                        <div class="form-group">
                                            <input type="number" class="form-control" placeholder="Phone"
                                                   id="phone" value="{{ old('phone') }}" name="phone">
                                        </div>

                                    </div>

                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <input type="email" class="form-control" placeholder="Email"
                                                   id="email" value="{{ old('name') }}" name="email">
                                        </div>
                                    </div>
                                    <div class="col-md-2">

                                        <div class="form-group">
                                            <div class="btn-area area002">
                                                <button type="button" class="btn btn1" id="verify">Send OTP</button>
                                            </div>
                                        </div>

                                    </div>
                                    <div class="col-md-2">

                                        <div class="form-group">
                                            <input type="number" class="form-control" placeholder="Otp" id="otp"
                                                   value="{{ old('otp') }}" name="otp">
                                        </div>

                                    </div>

                                    <div class="col-md-4">

                                        <div class="form-group">
                                            <input type="text" class="form-control" placeholder="Company Name"
                                                   id="company_name" value="{{ old('company_name') }}"
                                                   name="company_name">
                                        </div>

                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label></label>
                                            <select class="form-control" name="your_space" id="your_space">
                                                <option value="" hidden>Do you have measurements of your space?
                                                </option>
                                                <option value="No">No</option>
                                                <option value="Yes">Yes</option>
                                            </select>
                                        </div>

                                    </div>
                                    <div class="col-md-6 type_of_projects_list">
                                        <div class="form-group">
                                            <select class="form-control" name="project_type">
                                                <option value="" hidden>Type of project:</option>
                                                <option value="Kitchen Cabinet">Kitchen Cabinet</option>
                                                @if (!empty(SiteInfo::ourServices()))
                                                    @foreach (SiteInfo::ourServices() as $ourService)
                                                        <option value="{{ $ourService->name }}">{{ $ourService->name }}
                                                        </option>
                                                    @endforeach
                                                @endif
                                            </select>
                                        </div>

                                    </div>
                                    <div class="col-md-12" id="your_space_image">
                                        <div class="form-group">
                                            <div class="form-control file-div">
                                                <div class="file" id="yourBtn1" onclick="getFile()"> If yes, attach
                                                    measurements and photos
                                                    <input id="upfile1" class="upload-input" type="file"
                                                           value="upload" onchange="sub(this)" name="image">
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <select class="form-control js-example-basic-multiple-one" name="project[]"
                                                    multiple>
                                                <option value="" hidden>Which spaces are included in your project?
                                                </option>
                                                <option value="Bathroom">Bathroom</option>
                                                <option value="Entire Home">Entire Home</option>
                                                <option value="Kitchen">Kitchen</option>
                                            </select>
                                        </div>

                                    </div>
                                    {{-- <div class="col-md-6">
                                        <div class="form-group">
                                            <select class="form-control js-example-basic-multiple-two" name="interested[]"
                                                multiple>
                                                <option value="" hidden>Which products are you interested in?
                                                </option>
                                                <option value="Cabinets">Cabinets</option>
                                                <option value="Countertops">Countertops</option>
                                                <option value="Faucets">Faucets</option>
                                                <option value="Floating Shelves">Floating Shelves</option>
                                                <option value="Flooring">Flooring</option>
                                                <option value="Sinks">Sinks</option>
                                            </select>
                                        </div>

                                    </div> --}}
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <select class="form-control" name="budget_range">
                                                <option value="" hidden>Budget range :</option>
                                                <option value="Under $5,000">Under $5,000</option>
                                                <option value="$5,000 – $10,000">$5,000 – $10,000</option>
                                                <option value="$10,000 – $20,000">$10,000 – $20,000</option>
                                                <option value="Over $20,000">Over $20,000</option>

                                            </select>
                                        </div>

                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <select class="form-control" name="project_timeline">
                                                <option value="" hidden> Estimated project timeline :</option>
                                                <option value="0–1 month">0–1 month</option>
                                                <option value="1–3 months">1–3 months</option>
                                                <option value="3–6 months">3–6 months</option>
                                                <option value="6+ months">6+ months</option>

                                            </select>
                                        </div>

                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <select class="form-control" name="location">
                                                <option value="" hidden>Are you planning to visit one of our
                                                    locations?
                                                </option>
                                                <option value="No">No</option>
                                                <option value="Yes, Alpharetta">Yes, Alpharetta</option>
                                                <option value="Yes, Norcross">Yes, Norcross</option>

                                            </select>
                                        </div>

                                    </div>
                                    <div class="col-md-12">
                                        <div class="form-group">
                                            <textarea class="form-control" rows="4" cols="5" name="messages"
                                                      placeholder="Tell us more about your space! Have any questions? Include any additional details about your project you would like to share."
                                                      spellcheck="false">{{ old('messages') }}</textarea>
                                        </div>
                                    </div>
                                    <div class="d-none">
                                        <input type="text" name="website" value="">
                                        <input type="hidden" name="loaded_at" value="{{ time() }}">
                                        <input type="hidden" name="human_token" id="human_token" value="">
                                        <input type="hidden" name="js_enabled" id="js_enabled" value="0">
                                    </div>
                                    <div class="col-md-12">
                                        <div class="form-group">
                                            <label id="captchaQuestion"></label>
                                            <input type="text" id="captchaAnswer" class="form-control"
                                                   placeholder="Answer" required/>
                                            <small id="captchaError">Wrong answer. Try
                                                again.</small>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="btn-area area002">
                                <button type="submit" class="btn">Submit</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- video area -->
    <div class="video-main-area">
        <div class="container">
            <iframe width="100%" height="500" src="https://www.youtube.com/embed/{{ $YoutubeLink[1] }}"
                    title="YouTube video player" frameborder="0"
                    allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share"
                    referrerpolicy="strict-origin-when-cross-origin" allowfullscreen></iframe>
        </div>
    </div>



    <!-- member main -->
    @if (!empty($member))
        <div class="member-main" {{--style="background-image: url({{ $member->image }})"--}}>
            <div class="container">
                <div class="info-area">
                    <h4>{{ $member->title }}</h4>
                    <p>{!! $member->description !!}</p>
                    <div class="btn-area">
                        <a href="{{ route('frontend.signUp') }}" class="btn">Sign up</a>
                    </div>
                </div>
            </div>
        </div>
    @endif
    <!-- Guaranteed area -->
    @if (!empty($guaranteed))
        <div class="guaranteed-main">
            <div class="container">
                <div class="info">
                    <h3>{{ $guaranteed->shot_title }}</h3>
                    <h2>{{ $guaranteed->title }}</h2>
                    <p>
                        {!! $guaranteed->description !!}
                    </p>
                    <div class="btn-area">
                        <a href="#" class="btn">Learn More</a>
                    </div>
                </div>
            </div>
        </div>
    @endif

    @if (!empty(SiteInfo::brands()))
        <!--------- Brands area -------->
        <section class="brands_area ">
            <div class="container">
                <div class="owl-carousel owl-theme brand-slider">
                    @foreach (SiteInfo::brands() as $brandKey => $brand)
                        <div class="item">
                            <a href="#" class="pic-area">
                                <img src="{{ asset($brand->image) }}" alt="brand-{{ $brandKey }}" loading="lazy">
                            </a>
                        </div>
                    @endforeach
                </div>
            </div>
        </section>
        <!--------- Brands area -------->
    @endif
    @push('scripts')
        <script>
            window.addEventListener('load', function () {
                document.getElementById('js_enabled').value = "1";
            });
            const captchaQuestion = document.getElementById("captchaQuestion");
            const captchaInput = document.getElementById("captchaAnswer");
            const captchaError = document.getElementById("captchaError");

            let a = Math.floor(Math.random() * 10) + 1;
            let b = Math.floor(Math.random() * 10) + 1;
            let result = a + b;

            captchaQuestion.textContent = `What is ${a} + ${b}?`;

            document.getElementById("myForm").addEventListener("submit", function (e) {
                e.preventDefault(); // prevent form submission

                if (parseInt(captchaInput.value) === result) {
                    captchaError.style.display = "none";
                    // You can use this line to actually submit:
                    e.target.submit();
                } else {
                    captchaError.style.display = "block";
                }
            });
            $(document).ready(function () {

                setTimeout(() => {
                    document.getElementById('human_token').value = 'verified';
                }, 5000);
                $('.js-example-basic-multiple-one').select2({
                    placeholder: "Which spaces are included in your project?",
                    allowClear: true
                });
                $('.js-example-basic-multiple-two').select2({
                    placeholder: "Which products are you interested in?",
                    allowClear: true
                }); // Handler for .ready() called.
                $('#your_space_image').hide();
                $('#your_space').change(function () {
                    var selectedValue = $(this).val();
                    // Show the selected section
                    if (selectedValue === 'Yes') {
                        $('#your_space_image').show();
                    } else {
                        $('#your_space_image').hide();
                    }
                });
                @if (
                    $errors->has('name') ||
                        $errors->has('email') ||
                        $errors->has('phone') ||
                        $errors->has('messages') ||
                        Session::has('danger'))
                $('html, body').animate({
                    scrollTop: $('#form-section').offset().top
                }, 500);
                @endif
            });
            $("#verify").click(function (e) {
                var email = document.getElementById("email").value;
                document.getElementById('verify').innerText = 'Otp Sending ...';
                $.ajax({
                    url: "{{ route('frontend.quote_verify') }}",
                    type: "post",
                    data: {
                        _token: '{{ csrf_token() }}',
                        email: email
                    },
                    success: function (response) {
                        document.getElementById('verify').innerText = 'Send OTP';
                        if (response.status == 'success') {
                            toastr.success(response.msg, 'Success!');

                        } else {
                            toastr.error(response.msg, 'Warning!');
                        }
                    },
                    error: function (jqXHR, textStatus, errorThrown) {
                        console.log(textStatus, errorThrown);
                    }
                });

            });
        </script>
    @endpush
@endsection
