@extends('frontend.layout.layout')
@section('meta_tag')
    <title>{{ $seo->meta_title }}</title>
    <meta name="description" content="{{ $seo->meta_description }}">
    <meta name="keywords" content="{{ $seo->meta_keywords }}">
@endsection
@section('content')
    <style>
        .news-slider-main .news-slider-area .post-slide a .post-img {
            height: 324px !important;
        }

        .news-slider-main .news-slider-area .post-slide a .post-img img {
            object-fit: fill !important;
        }

        .cabinet_right_txt ul li {
            color: #000000 !important;
        }
    </style>
    <!-- <section class="main-slider-section inner_banner design-help-sec">
        <div class="inner_banner_info section-1">
            <div class="row align-items-center">
                <div class="col-md-6">
                    <div class="cabinet_right_txt">
                        <h2 class="cabinet_headeing">{{ $service->title1 ?? null }}</h2>
                        <h6>{!! $service->description1 ?? null !!}
                        </h6>
                        <ul>
                            <li><i class="fa fa-thumb-tack" aria-hidden="true"></i> {{ $service->title3 ?? null }}</li>
                            <li><i class="fa fa-thumb-tack" aria-hidden="true"></i> {{ $service->title4 ?? null }}</li>
                            <li><i class="fa fa-thumb-tack" aria-hidden="true"></i> {{ $service->title5 ?? null }}</li>
                            <li><i class="fa fa-thumb-tack" aria-hidden="true"></i> {{ $service->title6 ?? null }}</li>
                            <li><i class="fa fa-thumb-tack" aria-hidden="true"></i> {{ $service->title7 ?? null }}</li>
                            <li><i class="fa fa-thumb-tack" aria-hidden="true"></i> {{ $service->title8 ?? null }}</li>
                            <li><i class="fa fa-thumb-tack" aria-hidden="true"></i> {{ $service->title9 ?? null }}</li>
                        </ul>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="design-help-info">
                        <img src="{{ asset($service->image1 ?? null) }}" class="d-block w-100" alt="banner-1">
                    </div>
                </div>
            </div>
        </div>
    </section> -->

    <section class="protectedBy">
        <div class="container">
            <div class="row">
                <div class="col-md-4">
                    <div class="cabinet_right_txt">
                        <h2 class="cabinet_headeing">{{ $service->title1 ?? null }}</h2>
                        <h6>{!! $service->description1 ?? null !!}
                        </h6>
                        <ul>
                            <li><i class="fa fa-thumb-tack" aria-hidden="true"></i> {{ $service->title3 ?? null }}</li>
                            <li><i class="fa fa-thumb-tack" aria-hidden="true"></i> {{ $service->title4 ?? null }}</li>
                            <li><i class="fa fa-thumb-tack" aria-hidden="true"></i> {{ $service->title5 ?? null }}</li>
                            <li><i class="fa fa-thumb-tack" aria-hidden="true"></i> {{ $service->title6 ?? null }}</li>
                            <li><i class="fa fa-thumb-tack" aria-hidden="true"></i> {{ $service->title7 ?? null }}</li>
                            <li><i class="fa fa-thumb-tack" aria-hidden="true"></i> {{ $service->title8 ?? null }}</li>
                            <li><i class="fa fa-thumb-tack" aria-hidden="true"></i> {{ $service->title9 ?? null }}</li>
                        </ul>
                    </div>
                </div>
                <div class="col-md-4">
                    <img src="{{ asset($service->image1 ?? null) }}" class="d-block w-100" alt="{{ $service->title1 ?? null }}" height="350px" loading="lazy">
                </div>
                <div class="col-md-4">
                    <img src="{{ asset($service->image2 ?? null) }}" class="d-block w-100" alt="{{ $service->title2 ?? null }}" height="350px" loading="lazy">
                </div>
            </div>
        </div>
    </section>

    <!----------- Protected by section start ---------->
    <section class="protectedBy">
        <div class="container">
            <div class="sub-headline-area">
                <span></span>
                <h1 style="color: #000000 !important;">Kitchen Cabinet Solutions in Atlanta, Georgia</h1>
                <span></span>
            </div>
            <div class="sub-headline-area">
                <span></span>
                <h3>{{ $service->title17 ?? null }}</h3>
                <span></span>
            </div>
            <div class="row">
                <div class="col-lg-12">
                    <div class="protectedBy_div">

                        <h4>{{ $service->title18 ?? null }}</h4>
                        <p>
                            {!! $service->description8 ?? null !!}
                        </p>
                    </div>
                </div>

            </div>
        </div>
    </section>
    <!----------- Protected by section end ---------->
    <!-- contact us sec -->
    <div class="contact-section">
        <div class="container">
            <div class="sub-headline-area" style="margin-bottom: 0;">
                <span></span>
                <h3>GET YOUR QUOTE</h3>
                <span></span>
            </div>
            <div class="account-main-section" style="padding-top: 0;">
                <div class="container">
                    <div class="form-area part2" style="margin: 0;" id="form-section">
                        <form action="{{ route('frontend.quote_submit') }}" enctype="multipart/form-data" autocomplete="off"
                            method="POST" id="myForm">
                            @csrf
                            @include('backend.common.message')

                            <div class="area1">
                                <h3><span class="icon"></span>QUOTE</h3>
                                <div class="row" style=" border-bottom: 1px solid #000;">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <input type="text" class="form-control" placeholder="Full Name" id="name"
                                                value="{{ old('name') }}" name='name'>
                                        </div>
                                    </div>
                                    <div class="col-md-6">

                                        <div class="form-group">
                                            <input type="number" class="form-control" placeholder="Phone" id="phone"
                                                value="{{ old('phone') }}" name="phone">
                                        </div>

                                    </div>

                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <input type="email" class="form-control" placeholder="Email" id="email"
                                                value="{{ old('name') }}" name="email">
                                        </div>
                                    </div>
                                    <div class="col-md-2">

                                        <div class="form-group">
                                            <div class="btn-area area002">
                                                <button type="button" class="btn btn1" id="verify">Send OTP</button>
                                            </div>
                                        </div>

                                    </div>
                                    <div class="col-md-2">

                                        <div class="form-group">
                                            <input type="number" class="form-control" placeholder="Otp" id="otp"
                                                value="{{ old('otp') }}" name="otp">
                                        </div>

                                    </div>

                                    <div class="col-md-4">

                                        <div class="form-group">
                                            <input type="text" class="form-control" placeholder="Company Name"
                                                id="company_name" value="{{ old('company_name') }}" name="company_name">
                                        </div>

                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label></label>
                                            <select class="form-control" name="your_space" id="your_space"
                                                style="margin-top: .5rem;">
                                                <option value="" hidden>Do you have measurements of your space?
                                                </option>
                                                <option value="No">No</option>
                                                <option value="Yes">Yes</option>
                                            </select>
                                        </div>

                                    </div>
                                    <div class="col-md-6" style=" margin-top: 31px;">
                                        <div class="form-group">
                                            <select class="form-control" name="project_type">
                                                <option value="" hidden>Type of project: </option>
                                                <option value="Kitchen Cabinet">Kitchen Cabinet</option>
                                                @if (!empty(SiteInfo::ourServices()))
                                                    @foreach (SiteInfo::ourServices() as $ourService)
                                                        <option value="{{ $ourService->name }}">{{ $ourService->name }}
                                                        </option>
                                                    @endforeach
                                                @endif
                                            </select>
                                        </div>

                                    </div>
                                    <div class="col-md-12" id="your_space_image">
                                        <div class="form-group">
                                            <div class="form-control file-div">
                                                <div class="file" id="yourBtn1" onclick="getFile()"> If yes, attach
                                                    measurements and photos
                                                    <input id="upfile1" class="upload-input" type="file" value="upload"
                                                        onchange="sub(this)" name="image"
                                                        style="cursor: pointer; position: absolute; font-size: 50px; right: 0; top: 0; opacity: 0; width: 100%;">
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <select class="form-control js-example-basic-multiple-one" name="project[]"
                                                multiple>
                                                <option value="" hidden>Which spaces are included in your project?
                                                </option>
                                                <option value="Bathroom">Bathroom</option>
                                                <option value="Entire Home">Entire Home</option>
                                                <option value="Kitchen">Kitchen</option>
                                            </select>
                                        </div>

                                    </div>
                                    {{-- <div class="col-md-6">
                                        <div class="form-group">
                                            <select class="form-control js-example-basic-multiple-two" name="interested[]"
                                                multiple>
                                                <option value="" hidden>Which products are you interested in?
                                                </option>
                                                <option value="Cabinets">Cabinets</option>
                                                <option value="Countertops">Countertops</option>
                                                <option value="Faucets">Faucets</option>
                                                <option value="Floating Shelves">Floating Shelves</option>
                                                <option value="Flooring">Flooring</option>
                                                <option value="Sinks">Sinks</option>
                                            </select>
                                        </div>

                                    </div> --}}
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <select class="form-control" name="budget_range">
                                                <option value="" hidden>Budget range :</option>
                                                <option value="Under $5,000">Under $5,000</option>
                                                <option value="$5,000 – $10,000">$5,000 – $10,000</option>
                                                <option value="$10,000 – $20,000">$10,000 – $20,000</option>
                                                <option value="Over $20,000">Over $20,000</option>

                                            </select>
                                        </div>

                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <select class="form-control" name="project_timeline">
                                                <option value="" hidden> Estimated project timeline :</option>
                                                <option value="0–1 month">0–1 month</option>
                                                <option value="1–3 months">1–3 months</option>
                                                <option value="3–6 months">3–6 months</option>
                                                <option value="6+ months">6+ months</option>

                                            </select>
                                        </div>

                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <select class="form-control" name="location">
                                                <option value="" hidden>Are you planning to visit one of our
                                                    locations?</option>
                                                <option value="No">No</option>
                                                <option value="Yes, Alpharetta">Yes, Alpharetta</option>
                                                <option value="Yes, Norcross">Yes, Norcross</option>

                                            </select>
                                        </div>

                                    </div>
                                    <div class="col-md-12">
                                        <div class="form-group">
                                            <textarea class="form-control" rows="4" cols="5" name="messages"
                                                placeholder="Tell us more about your space! Have any questions? Include any additional details about your project you would like to share."
                                                spellcheck="false">{{ old('messages') }}</textarea>
                                        </div>
                                    </div>
                                    <div class="d-none">
                                        <input type="text" name="website" value="">
                                        <input type="hidden" name="loaded_at" value="{{ time() }}">
                                        <input type="hidden" name="human_token" id="human_token" value="">
                                        <input type="hidden" name="js_enabled" id="js_enabled" value="0">
                                    </div>
                                    <div class="col-md-12">
                                        <div class="form-group">
                                            <label id="captchaQuestion"></label>
                                            <input type="text" id="captchaAnswer" class="form-control" placeholder="Answer"
                                                required />
                                            <small id="captchaError" style="color:red; display:none;">Wrong answer. Try
                                                again.</small>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="btn-area area002">
                                <button type="submit" class="btn">Submit</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Blog -->
    @if (!empty($Galleries))
        <div class="news-slider-main mt-3">
            <div class="container">
                <div id="gallery-show" class="news-slider-area owl-carousel">
                    @foreach ($Galleries as $Gallery)
                        <div class="post-slide">
                            <a href="#">
                                <div class="post-img">
                                    <img src="{{ asset($Gallery->image) }}" alt="">
                                </div>
                            </a>
                            {{-- <div class="post-content">
                                <p class="post-description">{{ $store->title }}</p>
                            </div> --}}
                        </div>
                    @endforeach
                </div>
            </div>
        </div>
    @endif

    @push('scripts')
        <script>
            window.addEventListener('load', function () {
                document.getElementById('js_enabled').value = "1";
            });
            const captchaQuestion = document.getElementById("captchaQuestion");
            const captchaInput = document.getElementById("captchaAnswer");
            const captchaError = document.getElementById("captchaError");

            let a = Math.floor(Math.random() * 10) + 1;
            let b = Math.floor(Math.random() * 10) + 1;
            let result = a + b;

            captchaQuestion.textContent = `What is ${a} + ${b}?`;

            document.getElementById("myForm").addEventListener("submit", function (e) {
                e.preventDefault(); // prevent form submission

                if (parseInt(captchaInput.value) === result) {
                    captchaError.style.display = "none";
                    // You can use this line to actually submit:
                    e.target.submit();
                } else {
                    captchaError.style.display = "block";
                }
            });
            $(document).ready(function () {

                setTimeout(() => {
                    document.getElementById('human_token').value = 'verified';
                }, 5000);
                $('.js-example-basic-multiple-one').select2({
                    placeholder: "Which spaces are included in your project?",
                    allowClear: true
                });
                $('.js-example-basic-multiple-two').select2({
                    placeholder: "Which products are you interested in?",
                    allowClear: true
                }); // Handler for .ready() called.
                $('#your_space_image').hide();
                $('#your_space').change(function () {
                    var selectedValue = $(this).val();
                    // Show the selected section
                    if (selectedValue === 'Yes') {
                        $('#your_space_image').show();
                    } else {
                        $('#your_space_image').hide();
                    }
                });

                $("#verify").click(function (e) {
                    e.preventDefault;
                    var email = document.getElementById("email").value;
                    document.getElementById('verify').innerText = 'Otp Sending ...';
                    $.ajax({
                        url: "{{ route('frontend.quote_verify') }}",
                        type: "post",
                        data: {
                            _token: '{{ csrf_token() }}',
                            email: email
                        },
                        success: function (response) {
                            document.getElementById('verify').innerText = 'Send OTP';
                            if (response.status == 'success') {
                                toastr.success(response.msg, 'Success!');

                            } else {
                                toastr.error(response.msg, 'Warning!');
                            }
                        },
                        error: function (jqXHR, textStatus, errorThrown) {
                            console.log(textStatus, errorThrown);
                        }
                    });

                });
            });
        </script>
    @endpush
@endsection