@extends('frontend.layout.layout')
@section('meta_tag')
    <title>{{ SiteInfo::info()['site_name'] }}</title>
@endsection
@section('content')
    <div class="kitchen-main-sec margin_top">
        <div class="kitchen-banner-sec">
            <div class="subbanner-area2">
                <div class="container">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="subinfo">
                                <h3>
                                    {{ $kitchen_design->title_one ?? null }}
                                </h3>
                                <h5>
                                    Enter your email address below to get started for free now.
                                </h5>
                                <form action="{{ route('frontend.kitchen_design_submit') }}" class="form-area" method="POST"
                                    enctype="multipart/form-data">
                                    @csrf
                                    {{-- @include('backend.common.message') --}}
                                    <div class="form-area">
                                        <div class="form-group">
                                            <input type="email" class="form-control" name='email'placeholder="Email*">
                                        </div>
                                        <button type="submit" class="btn">Get Started</button>
                                    </div>
                                </form>
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" value="" id="flexCheckChecked"
                                        checked>
                                    <label class="form-check-label" for="flexCheckChecked">
                                        Sign up for emails on sales and discounts
                                    </label>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="img-area">
                                <img src="{{ asset($kitchen_design->image_one ?? null) }}" alt="">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="review-area">
            <img src="{{ asset($kitchen_design->image_two ?? null) }}" alt="">
        </div>
        <div class="kitchen-info-area">
            <div class="container">
                <div class="row">
                    <div class="col-md-6">
                        <div class="infobox">
                            <h4>{{ $kitchen_design->title_two ?? null }}</h4>
                            <p>{{ $kitchen_design->description_two ?? null }}</p>
                            <div class="btn-area">
                                <a href="{{ $kitchen_design->button_url ?? null }}" target="_blank" class="btn">Free
                                    Design
                                    Help</a>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="infobox">
                            <h4>{{ $kitchen_design->title_three ?? null }}</h4>
                            <p>{{ $kitchen_design->description_three ?? null }}</p>
                            <div class="btn-area">
                                <a href="#" class="btn area2"><span><img src="./assets/images/icon-phone-intro.webp"
                                            alt=""></span>{{ $kitchen_design->contact_number ?? null }}</a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    @push('scripts')
        <script>
            $(document).ready(() => {
                @if (Session::has('success') && !empty(Session::get('success')))
                    toastr.success('{{ Session::get('success') }}', 'Success!');
                @endif
            })
        </script>
    @endpush
@endsection
