@extends('frontend.layout.layout')
@section('meta_tag')
    <title>{{ SiteInfo::info()['site_name'] }}</title>
@endsection
@section('content')
    <style>
        .videoArea {
            display: none;
        }
    </style>
    <!--inner-banner -->
    <section class="inner_banner margin_top" style="background-image: url({{ asset('frontend/images/img-01.jpeg') }});">
        <div class="breadcrumbArea">
            <div class="container">

                <div class="page-title-content">
                    <h2>My orders</h2>
                    <ul class="d-flex">
                        <li><a href="{{ route('frontend.index') }}">Home</a></li>
                        <li>/</li>
                        <li class="main-pg"><a href="{{ route('frontend.my_orders') }}">My orders</a></li>
                        <li>/</li>
                        <li class="main-pg">Order details</li>
                    </ul>
                </div>
            </div>
        </div>
    </section>

    <!-- about us -->
    <section class="aboutUs sec-tb">
        <div class="container">
            <div class="card-body">
                <div class="invoice p-3 mb-3">

                    <div class="row invoice-info">
                        <div class="col-sm-3 invoice-col">
                            <h5><u>Customer Details</u></h5>
                            <address>
                                <b>Name:</b>
                                {{ $order->user_details->name }}<br>
                                @if (isset($order->user_details->mobile) && !empty($order->user_details->mobile))
                                    <b>Phone:</b> {{ $order->user_details->mobile ?? '-' }}<br>
                                @endif
                                <b>Email:</b> {{ $order->user_details->email ?? '-' }}
                            </address>
                        </div>
                        <div class="col-sm-3 invoice-col">
                            <h5><u>User Address</u></h5>
                            <address>
                                <b>Address:</b> {{ $order->order_details->address }}<br>
                                <b>House/Apartment:</b> {{ $order->order_details->apartment }}<br>
                                <b>City:</b> {{ $order->order_details->city }}<br>
                                <b>State:</b> {{ $order->order_details->state }}<br>
                                <b>Pincode:</b> {{ $order->order_details->pincode }}<br>
                            </address>
                        </div>
                        <div class="col-sm-3 invoice-col">
                            <h5><u>Order Details</u></h5>
                            <address>
                                <b>Order ID:</b> {{ $order->order_id }}<br>
                                <b>Order
                                    date:</b>
                                {{ date('d F Y, h:i A', strtotime($order->created_at)) ?? '-' }}
                                <br>
                            </address>
                        </div>
                        <div class="col-sm-3 invoice-col">
                            <h5><u>Pricing</u></h5>
                            <address>
                                @if (isset($order) && !empty($order))
                                    <b>Subtotal:</b> $
                                    {{ number_format($order->sub_total, 2, '.', '') }}<br>
                                    <b>Delivery Charge:</b> $
                                    {{ number_format($order->delivery_charge, 2, '.', '') }}<br>
                                    <b>Total:</b> $
                                    {{ number_format($order->total, 2, '.', '') }}<br>
                                @endif
                            </address>
                        </div>
                        {{-- <div class="col-sm-2 invoice-col">
                                    <h5>Payment Details</h5>
                                    <address>
                                        <b>Payment Mode:</b> CASH<br>
                                        <b>Reference Id:</b> <br>
                                        <b>Transaction Id:</b> <br>
                                    </address>
                                </div> --}}
                    </div>

                    <div class="row">
                        <div class="col-12">
                            <p class="lead"><u>Products</u></p>
                        </div>
                        <div class="col-12 table-responsive">
                            <table class="table table-striped">
                                <thead>
                                    <tr>
                                        {{--                                        <th>Image</th> --}}
                                        <th>Category</th>
                                        <th>Product Name</th>
                                        <th>Product Type</th>
                                        <th>Tag Name</th>
                                        <th>Length Name</th>
                                        <th>Color Name</th>
                                        <th>Combinition Name</th>
                                        <th>Price</th>
                                        <th>Quantity</th>
                                        <th>Payable Price</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @if (!empty($order_details))
                                        @foreach ($order_details as $orderDetail)
                                            <tr>
                                                {{--                                                <td><img --}}
                                                {{--                                                        src="{{ asset($orderDetail->image) }}"style="width: 75px;height: 75px;"> --}}
                                                {{--                                                </td> --}}
                                                <td>{{ $orderDetail->product->type->name ?? '-' }}</td>
                                                <td>{{ $orderDetail->product->name ?? '-' }}</td>
                                                <td>{{ $orderDetail->product_type_name ?? '-' }}</td>
                                                <td>{{ $orderDetail->tag_name ?? '-' }}</td>
                                                <td>{{ $orderDetail->length_name ?? '-' }}</td>
                                                <td>{{ $orderDetail->color_name ?? '-' }}</td>
                                                <td>{{ $orderDetail->name ?? '-' }}</td>
                                                <td>$ {{ number_format($orderDetail->main_price, 2, '.', '') }}</td>
                                                <td>{{ $orderDetail->quantity ?? '-' }}</td>
                                                <td>$ {{ number_format($orderDetail->payable_price, 2, '.', '') }}
                                                </td>

                                            </tr>
                                        @endforeach
                                    @endif
                                </tbody>
                            </table>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </section>
    @push('scripts')
        {{-- <script type="text/javascript">
            $(document).ready(function() {




                var table = $('#table').DataTable({
                    dom: '<"pl-2 pt-2 pr-2 pb-2" <"row" <"col-lg-6" l><"col-lg-3" f><"col-lg-3 text-right" B>> > rt <"border-top pl-2 pt-2 pr-2 pb-2 " <"row" <"col-lg-6" i><"col-lg-6" p>> >',
                    buttons: [
                        // {
                        //     text: '<i class="fa fa-plus-circle"></i>',
                        //     className: 'btn btn-sm btn-success datatable-button',
                        //     action: function(e, dt, node, config) {
                        //         window.location.href = '{{ route('backend.banner.create') }}';
                        //     }
                        // }
                    ],
                    lengthChange: false,
                    searching: false,
                    info: true,
                    paging: true,
                    searchHighlight: false,
                    ordering: false,
                    autoWidth: false,
                    responsive: true,
                    processing: true,
                    serverSide: true,
                    stateSave: false,
                    deferRender: true,
                    pageLength: 10,
                    order: false,
                    columnDefs: [{
                            orderable: false,
                            targets: [0, 1, 2, 3, 4, 5]
                        },
                        {
                            className: 'text-center',
                            targets: [0, 1, 2, 3, 4, 5]
                        },
                        {
                            width: '30px',
                            targets: 5
                        }
                    ],
                    ajax: {
                        url: '{{ route('frontend.my_orders') }}',
                        dataType: 'json',
                        type: 'GET',
                    },
                    columns: [{
                            data: 'order_id'
                        }, {
                            data: 'customer_name'
                        }, {
                            data: 'mobile'
                        }, {
                            data: 'price'
                        }, {
                            data: 'order_date'
                        },
                        {
                            data: 'action'
                        }
                    ]
                });
            });
        </script> --}}
    @endpush
@endsection
