@extends('frontend.layout.layout')
@section('meta_tag')
    <title>{{ SiteInfo::info()['site_name'] }}</title>
@endsection
@push('css')
    <link rel="stylesheet" href="{{ asset('backend/plugins/datatables-bs4/css/dataTables.bootstrap4.min.css') }}">
    <link rel="stylesheet"
          href="{{ asset('backend/plugins/datatables-responsive/css/responsive.bootstrap4.min.css') }}">
    <link rel="stylesheet" href="{{ asset('backend/plugins/datatables-buttons/css/buttons.bootstrap4.min.css') }}">
@endpush
@section('content')
    <!--inner-banner -->
    <section class="inner_banner margin_top" style="background-image: url({{ asset('frontend/images/img-01.jpeg') }});">
        <div class="breadcrumbArea">
            <div class="container">

                <div class="page-title-content">
                    <h2>My orders</h2>
                    <ul class="d-flex">
                        <li><a href="{{ route('frontend.index') }}">Home</a></li>
                        <li>/</li>
                        <li class="main-pg">My orders</li>
                    </ul>
                </div>
            </div>
        </div>
    </section>

    <!-- about us -->
    <section class="aboutUs sec-tb mb-5">
        <div class="container">
            <div class="row">
                <div class="col-sm-12 col-lg-12">
                    <table id="table-order" class="table m-0">
                        <thead>
                            <tr>
                                <th>Order ID</th>
                                <th>Customer Name</th>
                                <th>Mobile</th>
                                <th>Price</th>
                                <th>Order date</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                    </table>

                </div>
            </div>
        </div>
    </section>
    @push('scripts')
        <script src="{{ asset('backend/plugins/datatables/jquery.dataTables.min.js') }}"></script>
        <script src="{{ asset('backend/plugins/datatables-bs4/js/dataTables.bootstrap4.min.js') }}"></script>
        <script src="{{ asset('backend/plugins/datatables-responsive/js/dataTables.responsive.min.js') }}"></script>
        <script src="{{ asset('backend/plugins/datatables-responsive/js/responsive.bootstrap4.min.js') }}"></script>
        <script src="{{ asset('backend/plugins/datatables-buttons/js/dataTables.buttons.min.js') }}"></script>
        <script src="{{ asset('backend/plugins/datatables-buttons/js/buttons.bootstrap4.min.js') }}"></script>
        <script src="{{ asset('backend/plugins/datatables-buttons/js/buttons.html5.min.js') }}"></script>
        <script src="{{ asset('backend/plugins/datatables-buttons/js/buttons.print.min.js') }}"></script>
        <script src="{{ asset('backend/plugins/datatables-buttons/js/buttons.colVis.min.js') }}"></script>
        <script type="text/javascript">
            $(document).ready(function() {
                $('#table-order').DataTable({
                    lengthChange: false,
                    searching: false,
                    "bDestroy": true,
                    info: true,
                    paging: true,
                    searchHighlight: false,
                    ordering: false,
                    autoWidth: false,
                    responsive: true,
                    processing: true,
                    serverSide: true,
                    stateSave: false,
                    deferRender: true,
                    pageLength: 10,
                    order: false,
                    columnDefs: [{
                            orderable: false,
                            targets: [0, 1, 2, 3, 4, 5]
                        },
                        {
                            className: 'text-center',
                            targets: [0, 1, 2, 3, 4, 5]
                        },
                        {
                            width: '30px',
                            targets: 5
                        }
                    ],
                    ajax: {
                        url: '{{ route('frontend.my_orders') }}',
                        dataType: 'json',
                        type: 'GET',
                    },
                    columns: [{
                            data: 'order_id'
                        },
                        {
                            data: 'customer_name'
                        },
                        {
                            data: 'mobile'
                        },
                        {
                            data: 'price'
                        },
                        {
                            data: 'order_date'
                        },
                        {
                            data: 'action'
                        }
                    ]
                });
            });
        </script>
    @endpush
@endsection
