@extends('frontend.layout.layout')
@section('meta_tag')
    <title>{{ $service->meta_title }}</title>
    <meta name="title" content="{{ $service->meta_title }}">
    <meta name="description" content="{{ $service->meta_description }}">
    <meta name="keywords" content="{{ $service->meta_key }}">
@endsection
@section('content')
    {{-- @if ($id == 'bathroom-remodeling') --}}
    <style>
        .cabinet_right_txt ul li {
            color: #000000 !important;
        }
    </style>
    {{-- @endif --}}
    <!--------- banner start --------->
    <div class="main-slider-section inner_banner design-help-sec">
        <img src="{{ asset($service->image1 ?? null) }}" class="d-block w-100" alt="banner-1">
        <div class="inner_banner_info section-1">
            <div class="row align-items-center">
                <div class="col-md-6">
                    <div class="cabinet_right_txt">
                        <h2 class="cabinet_headeing">{{ $service->title1 ?? null }}</h2>
                        <h6>{!! $service->description1 ?? null !!}
                        </h6>
                        <ul>
                            <li><i class="fa fa-thumb-tack" aria-hidden="true"></i> {{ $service->title3 ?? null }}</li>
                            <li><i class="fa fa-thumb-tack" aria-hidden="true"></i> {{ $service->title4 ?? null }}</li>
                            <li><i class="fa fa-thumb-tack" aria-hidden="true"></i> {{ $service->title5 ?? null }}</li>
                            <li><i class="fa fa-thumb-tack" aria-hidden="true"></i> {{ $service->title6 ?? null }}</li>
                            <li><i class="fa fa-thumb-tack" aria-hidden="true"></i> {{ $service->title7 ?? null }}</li>
                            <li><i class="fa fa-thumb-tack" aria-hidden="true"></i> {{ $service->title8 ?? null }}</li>
                            <li><i class="fa fa-thumb-tack" aria-hidden="true"></i> {{ $service->title9 ?? null }}</li>
                        </ul>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="design-help-info">
                        <h3 style="font-size: 28px;">{{ $service->title2 ?? null }}</h3>
                        <form action="{{ route('frontend.services_submit') }}" class="form-area" method="POST"
                            enctype="multipart/form-data" id="myForm" autocomplete="off">
                            @csrf
                            @include('backend.common.message')
                            <input type="hidden" value="{{ $service->servisesmaster_id }}" name="id">
                            <div class="form-group">
                                <input type="text" class="form-control" name="name" placeholder="Full Name*">
                            </div>
                            <div class="form-group">
                                <input type="email" class="form-control" name="email" placeholder="Email*">
                            </div>
                            <div class="form-group">
                                <input type="number" class="form-control" name="phone" placeholder="Phone*">
                            </div>
                            <div class="form-group">
                                <div class="g-recaptcha" data-sitekey="{{ config('services.recaptcha.site_key') }}">
                                </div>
                            </div>

                            <button type="submit" class="btn" width="100%">Get Started</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!--------- banner end --------->


    <!---------- why choose us  section start --------->
    <section class="why_choose_us">
        <div class="container">
            <div class="row">
                <div class="col-md-7">
                    <div class="why_choose_us_img">
                        <img src="{{ asset($service->image2 ?? null) }}" alt="" loading="lazy">
                    </div>
                </div>
                <div class="col-md-5">
                    <div class="sub-headline-area">
                        <span></span>
                        <h3>{{ $service->title10 ?? null }}</h3>
                        <span></span>
                    </div>
                    <p>
                        {!! $service->description2 ?? null !!}
                    </p>
                </div>
            </div>
        </div>
    </section>
    <!---------- why choose us  section end --------->



    <!---------- 4 steps section start --------->
    <section class="four_steps">
        <div class="container">
            <div class="sub-headline-area">
                <span></span>
                <h3>{{ $service->title11 ?? null }}</h3>
                <span></span>
            </div>
            <ul class="steps_ul">
                <li>
                    <div class="step_div">
                        <h1>01</h1>
                        <strong>{{ $service->title12 ?? null }}</strong>
                        <p>
                            {!! $service->description3 ?? null !!}
                        </p>
                    </div>
                </li>
                <li>
                    <div class="step_div">
                        <h1>02</h1>
                        <strong>{{ $service->title13 ?? null }}</strong>
                        <p>
                            {!! $service->description4 ?? null !!}
                        </p>
                    </div>
                </li>
                <li>
                    <div class="step_div">
                        <h1>03</h1>
                        <strong>{{ $service->title14 ?? null }}</strong>
                        <p>
                            {!! $service->description5 ?? null !!}
                        </p>
                    </div>
                </li>
                <li>
                    <div class="step_div">
                        <h1>04</h1>
                        <strong>{{ $service->title15 ?? null }}</strong>
                        <p>
                            {!! $service->description6 ?? null !!}
                        </p>
                    </div>
                </li>
            </ul>
        </div>
    </section>
    <!---------- 4 steps section end --------->



    <!--------------- review area start --------------->
    @if (!empty($customerReviews) && isset($customerReviews))
        <section class="testimonial-main">
            <div class="container">
                <div class="heading text-center">
                    <div class="sub-headline-area">
                        <span></span>
                        <h3>{{ SiteInfo::title()['title7'] ?? null }}</h3><span></span>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <div id="testimonial-slider" class="testimonial-slider-area owl-carousel">
                                @foreach ($customerReviews as $customerReview)
                                    <div class="post-slide">
                                        <ul class="listgroup">
                                            <li class="line0 d-flex justify-content-center">
                                                <!--<img src="{{ asset($customerReview->image) }}" alt=""
                                                                                                                style="
    width: 50px;
    height: 50px;
    border-radius: 50%;">
                                                                                                        </li>-->
                                            <li class="line1">
                                                {{ Carbon\Carbon::parse($customerReview->created_at)->diffForHumans() }}
                                            </li>
                                            <li class="line2">{{ $customerReview->name }}</li>
                                            @if ($customerReview->verified == 1)
                                                <li class="line3"><span><i class="fa fa-check-circle"
                                                            aria-hidden="true"></i>
                                                    </span>Verified Buyer
                                                </li>
                                            @else
                                                <li class="line3">&nbsp</li>
                                            @endif
                                        </ul>
                                        <ul class="starmark">
                                            @if (!empty($customerReview->retting))
                                                @for ($i = 1; $i <= $customerReview->retting; $i++)
                                                    <li><i class="fa fa-star" aria-hidden="true"></i></li>
                                                @endfor
                                            @endif
                                            @if (5 - $customerReview->retting != 0)
                                                @for ($i = 1; $i <= 5 - $customerReview->retting; $i++)
                                                    <li><i class="fa fa-star-o" aria-hidden="true"></i></li>
                                                @endfor
                                            @endif
                                        </ul>
                                        {{-- <h3>Great quality material Colors are</h3> --}}
                                        <p style="overflow-y: auto !important; height: 100px!important">
                                            {{ $customerReview->commend }}</p>
                                    </div>
                                @endforeach
                            </div>
                            <div class="btn-area">
                                <ul>
                                    <li><a href="{{ route('frontend.customerReviews') }}" class="btn type1">View All
                                            Reviews</a></li>
                                </ul>
                            </div>

                        </div>
                    </div>
                </div>
            </div>
        </section>
    @endif
    <!--------------- review area end --------------->



    <!---------- designer talk start --------->
    <section class="designer_talk_div">
        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1440 320">
            <path fill="#ffc35c" fill-opacity="1"
                d="M0,192L360,160L720,256L1080,256L1440,0L1440,320L1080,320L720,320L360,320L0,320Z"></path>
        </svg>
        <div class="container">
            <div class="designer_talk">
                <h3>{{ $service->title16 ?? null }}</h3>
                <p>
                    {!! $service->description7 ?? null !!}
                </p>
                <ul>
                    <li><a href="#" class="btn type1"><i class="fa fa-phone" aria-hidden="true"></i>
                            {{ SiteInfo::info()['phone_call'] }}</a></li>
                </ul>
            </div>
        </div>
    </section>
    <!---------- designer talk end --------->

    <!----------- Protected by section start ---------->
    <section class="protectedBy">
        <div class="container">
            <div class="sub-headline-area">
                <span></span>
                <h3>{{ $service->title17 ?? null }}</h3>
                <span></span>
            </div>
            <div class="row">
                <div class="col-lg-4">
                    <div class="protectedBy_div">
                        <i class="fa fa-id-card-o" aria-hidden="true"></i>
                        <h4>{{ $service->title18 ?? null }}</h4>
                        <p>
                            {!! $service->description8 ?? null !!}
                        </p>
                    </div>
                </div>
                <div class="col-lg-4">
                    <div class="protectedBy_div">
                        <i class="fa fa-pencil" aria-hidden="true"></i>
                        <h4>{{ $service->title19 ?? null }}</h4>
                        <p>
                            {!! $service->description9 ?? null !!}
                        </p>
                    </div>
                </div>
                <div class="col-lg-4">
                    <div class="protectedBy_div">
                        <i class="fa fa-check" aria-hidden="true"></i>
                        <h4>{{ $service->title20 ?? null }}</h4>
                        <p>
                            {!! $service->description10 ?? null !!}
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!----------- Protected by section end ---------->


    <!---------- award winning section start --------->
    <section class="why_choose_us">
        <div class="container">
            <div class="row">
                <div class="col-md-6">
                    <div class="sub-headline-area">
                        <span></span>
                        <h3>{{ $service->title21 ?? null }}</h3>
                        <span></span>
                    </div>
                    {!! $service->description11 ?? null !!}
                </div>
                <div class="col-md-6">
                    <div class="award_winningImg">
                        <img src="{{ asset($service->image3 ?? null) }}" alt="" loading="lazy">
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!---------- award winning section end --------->



    <!--------- free estimation start --------->
    <!--<div class="main-slider-section inner_banner design-help-sec">
                                                                    <img src="{{ asset($service->image4 ?? null) }}" class="d-block w-100" alt="banner-1">
                                                                    <div class="inner_banner_info section-1">
                                                                        <div class="row align-items-center g-5">
                                                                            <div class="col-md-6">
                                                                                <div class="design-help-info">
                                                                                    <form action="{{ route('frontend.services_submit') }}" class="form-area" method="POST"
                                                                                        enctype="multipart/form-data">
                                                                                        @csrf
                                                                                        @include('backend.common.message')
                                                                                        <input type="hidden" value="{{ $service->servisesmaster_id }}" name="id">

                                                                                        <div class="form-group">
                                                                                            <input type="text" class="form-control" name="name" placeholder="Full Name*">
                                                                                        </div>
                                                                                        <div class="form-group">
                                                                                            <input type="email" class="form-control" name="email" placeholder="Email*">
                                                                                        </div>
                                                                                        <div class="form-group">
                                                                                            <input type="number" class="form-control" name="phone" placeholder="Phone*">
                                                                                        </div>

                                                                                        <button type="submit" class="btn" width="100%">Get your FREE estimate</button>
                                                                                    </form>
                                                                                </div>
                                                                            </div>
                                                                            <div class="col-md-6">
                                                                                <div class="cabinet_right_txt">
                                                                                    <h2 class="cabinet_headeing">{{ $service->title22 ?? null }}</h2>
                                                                                    <h6>{!! $service->description12 ?? null !!}</h6>
                                                                                    <ul>
                                                                                        <li><i class="fa fa-thumb-tack" aria-hidden="true"></i> {{ $service->title23 ?? null }}</li>
                                                                                        <li><i class="fa fa-thumb-tack" aria-hidden="true"></i> {{ $service->title24 ?? null }}
                                                                                        </li>
                                                                                        <li><i class="fa fa-thumb-tack" aria-hidden="true"></i> {{ $service->title25 ?? null }}</li>
                                                                                        <li><i class="fa fa-thumb-tack" aria-hidden="true"></i> {{ $service->title26 ?? null }}</li>
                                                                                        <li><i class="fa fa-thumb-tack" aria-hidden="true"></i> {{ $service->title27 ?? null }}</li>
                                                                                        <li><i class="fa fa-thumb-tack" aria-hidden="true"></i> {{ $service->title28 ?? null }}</li>
                                                                                        <li><i class="fa fa-thumb-tack" aria-hidden="true"></i> {{ $service->title29 ?? null }}</li>
                                                                                    </ul>
                                                                                </div>
                                                                            </div>

                                                                        </div>
                                                                    </div>
                                                                </div>-->
    <!--------- free estimation end --------->



    <!------------- video area start ------------->
    <!--<div class="video-main-area video_feedback">
                                                                    <div class="container">
                                                                        <div class="sub-headline-area">
                                                                            <span></span>
                                                                            <h3>{{ $service->title30 ?? null }}</h3>
                                                                            <span></span>
                                                                        </div>
                                                                        <div class="row">
                                                                            <div class="col-md-6">
                                                                                <iframe width="100%" height="300" src="https://www.youtube.com/embed/{{ $YoutubeLink1[1] }}"
                                                                                    title="YouTube video player" frameborder="0"
                                                                                    allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share"
                                                                                    referrerpolicy="strict-origin-when-cross-origin" allowfullscreen></iframe>
                                                                                <div class="iframe_txt_div">
                                                                                    <ul class="star_ul">
                                                                                        @if (!empty($service->star1))
    @for ($i = 1; $i <= $service->star1; $i++)
    <li><i class="fa fa-star" aria-hidden="true"></i></li>
    @endfor
    @endif
                                                                                        @if (5 - $service->star1 != 0)
    @for ($i = 1; $i <= 5 - $service->star1; $i++)
    <li><i class="fa fa-star-o" aria-hidden="true"></i></li>
    @endfor
    @endif
                                                                                    </ul>
                                                                                    <p>
                                                                                        {!! $service->description13 ?? null !!}
                                                                                    </p>
                                                                                    <span style="color: #db951c;">- {{ $service->name1 }}</span>
                                                                                </div>

                                                                            </div>
                                                                            <div class="col-md-6">
                                                                                <iframe width="100%" height="300" src="https://www.youtube.com/embed/{{ $YoutubeLink2[1] }}"
                                                                                    title="YouTube video player" frameborder="0"
                                                                                    allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share"
                                                                                    referrerpolicy="strict-origin-when-cross-origin" allowfullscreen></iframe>
                                                                                <div class="iframe_txt_div">
                                                                                    <ul class="star_ul">
                                                                                        @if (!empty($service->star2))
    @for ($i = 1; $i <= $service->star2; $i++)
    <li><i class="fa fa-star" aria-hidden="true"></i></li>
    @endfor
    @endif
                                                                                        @if (5 - $service->star2 != 0)
    @for ($i = 1; $i <= 5 - $service->star2; $i++)
    <li><i class="fa fa-star-o" aria-hidden="true"></i></li>
    @endfor
    @endif
                                                                                    </ul>
                                                                                    <p>
                                                                                        {!! $service->description14 ?? null !!}
                                                                                    </p>
                                                                                    <span style="color: #db951c;">- {{ $service->name2 }}</span>
                                                                                </div>

                                                                            </div>
                                                                        </div>
                                                                    </div>

                                                                </div>-->
    <!------------- video area end ------------->


    <!------------- our_projects area start ------------->

    @if (!empty($stores))
        <div class="our_projects">
            <div class="container">
                <div class="sub-headline-area">
                    <span></span>
                    <h3>Our Projects</h3>
                    <span></span>
                </div>
                <div class="owl-carousel owl-theme project_slider">
                    @foreach ($stores as $store)
                        <div class="item">
                            <img src="{{ asset($store->image) }}" alt="" loading="lazy">
                        </div>
                    @endforeach
                </div>
            </div>
        </div>
    @endif
    <!-- </div> -->
    <!------------- our_projects area end ------------->

    <!------------- Visit Our Showrooms area start ------------->
    <div class="our_projects visit_showroom">
        <div class="container">
            <div class="row">

                <div class="col-md-6">
                    <div class="showroom_address_div">
                        <div class="sub-headline-area">
                            <span></span>
                            <h3>{{ $service->title31 ?? null }}</h3>
                            <span></span>
                        </div>
                        <ul class="showroom_address_ul">
                            <li>
                                <h6><i class="fa fa-map-marker" aria-hidden="true"></i> Location</h6>
                                <p class="text-white">Norcross</p>

                                <p><a style="color: #9f9f9fc7;"
                                        href="https://www.google.com/maps/place/6796+Jimmy+Carter+Blvd+STE+G,+Norcross,+GA+30071,+USA/@33.9391813,-84.2402713,17z/data=!3m1!4b1!4m6!3m5!1s0x88f5a190ffdaab37:0x5d239667ab456deb!8m2!3d33.9391813!4d-84.2376964!16s%2Fg%2F11vt4sz_80?entry=ttu&g_ep=EgoyMDI1MDMwMy4wIKXMDSoASAFQAw%3D%3D"
                                        target="_blank"><i class="fa fa-map-marker" aria-hidden="true"></i>
                                        {{ SiteInfo::info()['address'] }}</a></p>
                                <p><i class="fa fa-phone" aria-hidden="true"></i>
                                    {{ SiteInfo::info()['phone_call'] }}</p>
                                <p class="text-white">Alpharetta</p>
                                <p><a style="color: #9f9f9fc7;"
                                        href="https://www.google.com/maps/place/1000+North+Point+Cir,+Alpharetta,+GA+30022,+USA/@34.0492659,-84.2979273,17z/data=!3m1!4b1!4m6!3m5!1s0x88f5751471ae99d3:0xdee9ff56228bb6dc!8m2!3d34.0492659!4d-84.2953524!16s%2Fg%2F11bw3g9wmd?entry=ttu&g_ep=EgoyMDI1MDMwMy4wIKXMDSoASAFQAw%3D%3D"
                                        target="_blank"><i class="fa fa-map-marker" aria-hidden="true"></i>
                                        {{ SiteInfo::info()['address1'] }}</a></p>
                                <p><i class="fa fa-phone" aria-hidden="true"></i>4709002141</p>
                            </li>

                            <li>
                                <h6><i class="fa fa-envelope" aria-hidden="true"></i> Email</h6>
                                <p>{{ SiteInfo::info()['email'] }}</p>
                            </li>
                        </ul>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="showroom_img">
                        <img src="{{ asset($service->image5 ?? null) }}" alt="" loading="lazy">
                    </div>
                </div>
            </div>

        </div>
    </div>
    <!------------- Visit Our Showrooms area end ------------->


    <!---------- designer talk start --------->
    <section class="designer_talk_div">
        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1440 320">
            <path fill="#ffc35c" fill-opacity="1"
                d="M0,192L360,160L720,256L1080,256L1440,0L1440,320L1080,320L720,320L360,320L0,320Z"></path>
        </svg>
        <div class="container">
            <div class="designer_talk">
                <h3>
                    {{ $service->title32 ?? null }}</h3>
                <p>
                    {!! $service->description15 ?? null !!}
                </p>
                <ul>
                    <li><a href="#" class="btn type1"><i class="fa fa-phone" aria-hidden="true"></i>
                            {{ SiteInfo::info()['phone_call'] }}</a></li>
                </ul>
            </div>
        </div>
    </section>
    <!---------- designer talk end --------->
@endsection
