@extends('frontend.layout.layout')
@section('meta_tag')
    <title>{{ SiteInfo::info()['site_name'] }}</title>
@endsection
@section('content')
    <style>
        .pricing-sec {
            margin-top: 80px;
        }
    </style>
    <div class="pricing-sec">
        <div class="about-info-sec">
            <div class="container">
                <div class="info-1">
                    <h3>{{ $pricingTitle->title_one ?? null }}</h3>
                    <p>
                        {{ $pricingTitle->description_one ?? null }}
                    </p>
                </div>

                @if (!empty($services))
                    <div class="info-2">
                        <div class="row"
                            style="
    display: flex
;
    flex-direction: row;
    justify-content: center;">
                            @foreach ($services as $service)
                                <div class="col-md-3 cl-area">
                                    <a href="{{ $service->link }}">
                                        <div class="box">
                                            <div class="icon">
                                                <img src="{{ asset($service->image ?? null) }}" alt="">
                                            </div>
                                            <div class="info">
                                                <h5>{{ $service->title ?? null }}</h5>
                                                <p>{{ $service->description ?? null }}</p>
                                            </div>
                                        </div>
                                    </a>
                                </div>
                            @endforeach
                        </div>

                    </div>
                @endif
            </div>
        </div>
        <div class="ship-form-sec">
            <div class="container">
                <div class="headarea">
                    <h3>{{ $pricingTitle->title_two ?? null }}</h3>
                </div>
                <form action="{{ route('frontend.pricing_submit') }}" method="POST" enctype="multipart/form-data">
                    @csrf
                    @include('backend.common.message')
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <input type="text" class="form-control" placeholder="Name" name="name">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <input type="email" class="form-control" placeholder="Email" name="email">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <input type="text" class="form-control" placeholder="Order No" name="order_no">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <input type="text" class="form-control" placeholder="Zip No" name="zip_no">
                            </div>
                        </div>
                        <div class="col-md-12">
                            <div class="form-group">
                                <textarea name="messages" id="" cols="3" class="form-control" placeholder="Comment"></textarea>
                            </div>
                        </div>
                        <div class="col-md-12">
                            <div class="form-group">
                                <label for="">Customer Type</label>
                                <div class="form-group-area">
                                    <div class="form-check">
                                        <input class="form-check-input" type="radio" name="customerType"
                                            value="Residential" id="flexRadioDefault1">
                                        <label class="form-check-label" for="flexRadioDefault1">
                                            Residential
                                        </label>
                                    </div>
                                    <div class="form-check">
                                        <input class="form-check-input" type="radio" name="customerType"
                                            value="Commercial" id="flexRadioDefault2" checked>
                                        <label class="form-check-label" for="flexRadioDefault2">
                                            Commercial
                                        </label>
                                    </div>
                                </div>

                            </div>
                        </div>
                        <div class="col-md-12">
                            <div class="form-group">
                                <div class="mb-3">
                                    <label for="formFile" class="form-label">Attachment (photo of your shopping cart
                                        printout or a pdf
                                        copy of the quote)</label>
                                    <input class="form-control" type="file" id="formFile" name="image">
                                </div>
                            </div>
                        </div>
                        <div class="btn-area">
                            <button type="submit" class="btn px-5">Submit</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
        @if (!empty($contents))
            <div class="info-card-area">
                <div class="container">
                    <div class="row">
                        @foreach ($contents as $content)
                            <div class="col-md-4">
                                <div class="card-area">
                                    <div class="img-area">
                                        <img src="{{ asset($content->image) ?? null }}" alt="">
                                    </div>
                                    <div class="info">
                                        <h5>{{ $content->title }}</h5>
                                        <p>{{ $content->description }}
                                        </p>
                                        @if ($content->price != null)
                                            <h4>${{ $content->price }}</h4>
                                        @endif
                                        <a href="{{ $content->link }}" class="btn">Explore</a>
                                    </div>
                                </div>
                            </div>
                        @endforeach

                    </div>
                </div>
            </div>
        @endif
    </div>
@endsection
