@extends('frontend.layout.layout')
@section('meta_tag')
    <title>{{ SiteInfo::info()['site_name'] }}</title>
@endsection
@section('content')
    <style>
        .red-color {
            background: #198754 !important;
        }

        .product-details-sec .product-info-sec .info-area-sec .product-item .table tr .btn {
            background-color: #c29634 !important;
        }

        .product-details-sec .product-info-sec .product-filter-area {
            display: unset !important;
        }
    </style>
    <!-- breadcrumb -->
    <div class="breadcrumb-sec">
        <div class="container">
            <ul>
                <li><a href="{{ route('frontend.index') }}">Home</a></li>
                <li><span>/</span></li>
                <li><a href="{{ route('frontend.type', $category_id) }}">Product</a></li>
                <li><span>/</span></li>
                <li>{{ $product->color->name }}</li>
            </ul>
        </div>
    </div>

    <!-- product details section -->
    <div class="product-details-sec">
        <div class="container">

            <div class="row">
                <div class="col-md-6 col-lg-4">
                    <div class="details-slider">
                        <div id="carouselExampleIndicators" class="carousel slide" data-bs-ride="carousel">
                            <!-- class="carousel slide" data-interval="false"> -->
                            <div class="carousel-indicators">
                                @if (!empty($productImages))
                                    @foreach ($productImages as $key => $productImage)
                                        <button type="button" data-bs-target="#carouselExampleIndicators"
                                                data-bs-slide-to="{{ $key }}"
                                                @if ($key == 0) class="active" @endif aria-current="true"
                                                aria-label="Slide {{ $key + 1 }}">
                                            <div class="slide-icon">
                                                <img src="{{ asset($productImage['image']) }}" alt="">
                                            </div>
                                        </button>
                                    @endforeach
                                @endif
                            </div>
                            <div class="carousel-inner">
                                @if (!empty($productImages))
                                    @foreach ($productImages as $key1 => $productImage)
                                        <div class="carousel-item @if ($key1 == 0) active @endif">
                                            <div class="product-pic">
                                                <img src="{{ asset($productImage['image']) }}" alt=""
                                                     style="height: 350px;object-fit: contain;">
                                            </div>
                                        </div>
                                    @endforeach
                                @endif
                            </div>
                            <button class="carousel-control-prev" type="button"
                                    data-bs-target="#carouselExampleIndicators"
                                    data-bs-slide="prev">
                                <span class="carousel-control-prev-icon" aria-hidden="true"></span>
                                <span class="visually-hidden">Previous</span>
                            </button>
                            <button class="carousel-control-next" type="button"
                                    data-bs-target="#carouselExampleIndicators"
                                    data-bs-slide="next">
                                <span class="carousel-control-next-icon" aria-hidden="true"></span>
                                <span class="visually-hidden">Next</span>
                            </button>
                        </div>
                    </div>
                </div>

                <div class="col-md-6 col-lg-8 detail-area01"
                     style="background-image: url('{{ asset($product->background_image ?? null) }}');">
                    <div class="product-info">
                        <h5>Details</h5>
                        <p>{!! $product->description !!}</p>

                    </div>
                </div>
            </div>
            <div class="product-info-sec">
                @if (!empty($colors) || !empty($tags))
                    <div class="product-filter-area">
                        <div class="row">
                            @if (!empty($colors))
                                <div class="col-md-4">
                                    <div class="area1 mb-2">
                                        <select class="form-select" aria-label="" onchange="getColor(this.value)">
                                            <option value="" hidden>Change Collection</option>
                                            @foreach ($colors as $color)
                                                <option value="{{ $color->id }}">{{ $color->name }}</option>
                                            @endforeach

                                        </select>
                                    </div>
                                </div>
                            @endif
                            @if (!empty($tags))
                                <div class="col-md-8">
                                    <div class="tab-area">
                                        <ul>
                                            <li><a href="{{ url()->current() }}">All</a></li>
                                            @foreach ($tags as $tag)
                                                <li>
                                                    <a @if (!empty($filter_tag_id) && $filter_tag_id == $tag->id) class="active"
                                                       @endif
                                                       href="{{ url()->current() }}?tag={{ $tag->id }}&product_id={{ $product_id }}">{{ $tag->name }}</a>
                                                </li>
                                            @endforeach
                                        </ul>
                                    </div>
                                </div>
                            @endif
                        </div>


                    </div>
                @endif
                <div class="info-area-sec">
                    @if (!empty($productTypes))
                        @foreach ($productTypes as $productType)
                            <div class="info-area">
                                <h3><span class="icon"></span>{{ $productType->name }}</h3>
                                <div class="product-item">
                                    <div class="row">
                                        <div class="col-md-2 col-lg-2">
                                            <div class="img-area">
                                                <img src="{{ asset($productType->image) }}" alt="">
                                            </div>
                                        </div>
                                        <div class="col-md-10 col-lg-10">
                                            <div class="table-responsive">
                                                <table class="table">
                                                    <thead>
                                                    <tr>
                                                        <th scope="col">SKU</th>
                                                        <th scope="col">Dimension</th>
                                                        <th scope="col">Price</th>
                                                        <th scope="col"></th>
                                                    </tr>
                                                    </thead>
                                                    <tbody>
                                                    @if (!empty(SiteInfo::productCombination($productType->id, $filter_tag_id, $product_id)))
                                                        @foreach (SiteInfo::productCombination($productType->id, $filter_tag_id, $product_id) as $productCombination)
                                                            <tr>
                                                                <td style="padding-top: 12px;">
                                                                    <p>{{ $productCombination->name }}</p>
                                                                </td>
                                                                <td style="padding-top: 12px;">{{ $productCombination->dimension }}</td>
                                                                @php
                                                                    $discount = App\Models\DiscountProduct::where(
                                                                        'product_id',
                                                                        $product_id,
                                                                    )
                                                                        ->where('color_id', $color_id)
                                                                        ->where('category', $category_id)
                                                                        ->where('product_type_id', $productType->id)
                                                                        ->where(
                                                                            'tag_id',
                                                                            $productCombination->tag_id,
                                                                        )
                                                                        ->where(
                                                                            'product_combination_id',
                                                                            $productCombination->id,
                                                                        )
                                                                        ->where('color_master_id', $color_master_id)
                                                                        ->first();
                                                                    if (!empty($discount) || isset($discount)) {
                                                                        if ($discount->discount == 1) {
                                                                            if ($discount->type == 2) {
                                                                                $total_price =
                                                                                    $productCombination->discount_price +
                                                                                    $discount->dis_amount;
                                                                                $discount_price = $total_price;
                                                                            } else {
                                                                                $discuntPercentage =
                                                                                    ($discount->dis_amount / 100) *
                                                                                    $productCombination->discount_price;
                                                                                $total_price =
                                                                                    $productCombination->discount_price +
                                                                                    $discuntPercentage;
                                                                                $discount_price = $total_price;
                                                                            }
                                                                        } else {
                                                                            if ($discount->type == 2) {
                                                                                $total_price =
                                                                                    $productCombination->discount_price -
                                                                                    $discount->dis_amount;
                                                                                $discount_price = $total_price;
                                                                            } else {
                                                                                $discuntPercentage =
                                                                                    ($discount->dis_amount / 100) *
                                                                                    $productCombination->discount_price;
                                                                                $total_price =
                                                                                    $productCombination->discount_price -
                                                                                    $discuntPercentage;
                                                                                $discount_price = $total_price;
                                                                            }
                                                                        }
                                                                    } else {
                                                                        $discount_price =
                                                                            $productCombination->discount_price;
                                                                    }
                                                                @endphp
                                                                <td style="padding-top: 12px;">
                                                                    {{--                                                                    @dd($productCombination) --}}
                                                                    {{-- @if (auth()->check() == true) --}}
                                                                    <div class="d-flex">
                                                                        <p>${{ $discount_price }}
                                                                        </p> &nbsp
                                                                        @if(!empty($productCombination->main_price) || $productCombination->main_price > 0)
                                                                            <p style="color: red;text-decoration: line-through;">
                                                                                ${{$productCombination->main_price}}</p>
                                                                        @endif
                                                                    </div>
                                                                    {{-- @else
                                                                    <p>$-- --</p>
                                                                @endif --}}
                                                                </td>
                                                                <td>
                                                                    @if (auth()->check() == true)
                                                                        @php($cart = App\Models\Cart::where(['user_id' => auth()->id(), 'product_combination_id' => $productCombination->id])->count())
                                                                    @else
                                                                        @php($cart = App\Models\Cart::where(['user_id' => auth()->id(), 'product_combination_id' => $productCombination->id])->count())
                                                                    @endif
                                                                    {{--                                                                    @if (auth()->check() == true) --}}
                                                                    @if ($cart > 0)
                                                                        <a href="javascript:void(0)"
                                                                           class="btn" style=" font-size: 11px;padding: 6px;">Added in
                                                                            cart</a>
                                                                    @else
                                                                        <a href="javascript:void(0)"
                                                                           onclick="pushOnCart('{{ $productCombination->id }}')"
                                                                           class="btn" style="background: #198754; font-size: 11px"
                                                                           id="cart_{{ $productCombination->id }}">Add
                                                                            to
                                                                            cart</a>
                                                                    @endif
                                                                    {{--                                                                    @else --}}
                                                                    {{--                                                                        <a href="{{ route('frontend.login') }}" --}}
                                                                    {{--                                                                           class="btn">Sign in</a> --}}
                                                                    {{--                                                                    @endif --}}
                                                                </td>
                                                            </tr>
                                                        @endforeach
                                                    @endif

                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    @endif

                </div>
            </div>
        </div>
    </div>
    @push('scripts')
        <script>
            function pushOnCart(combination) {
                // $("#loader").show();
                $.ajax({
                    url: "{{ route('frontend.cart') }}",
                    type: "post",
                    data: {
                        _token: '{{ csrf_token() }}',
                        combination,
                    },
                    success: function (response) {
                        if (response.status == 'success') {
                            toastr.success(response.msg, 'Success!');
                            $(`#cart_${combination}`).text('Added cart');
                            $(`#cart_${combination}`).addClass("red-color");
                            $(`#cart_count`).html(`(${response.data.cart_count})`);
                            $(`#cart_count1`).html(`(${response.data.cart_count})`);

                        } else {
                            toastr.error(response.msg, 'Warning!');
                        }
                    },
                    error: function (jqXHR, textStatus, errorThrown) {
                        console.log(textStatus, errorThrown);
                    }
                });
            }

            function getColor(color_id) {
                let color_master_id = '{{ $color_master_id }}';
                let category_id = '{{ $category_id }}';
                let route = '{{ route('frontend.index') }}' + `/product-details/${color_id}/${color_master_id}/${category_id}`;
                window.location.href = route;
            }
        </script>
    @endpush
@endsection
