@extends('frontend.layout.layout')
@section('meta_tag')
    <title>{{ SiteInfo::info()['site_name'] }}</title>
@endsection
@section('content')
    <!-- ====== quick ship Start ====== -->
    <div class="sub-banner-sec">
        <div class="img-area">
            <img src="{{ asset($quickShipTitle->background_image) ?? null }}" alt="">
            <div class="info-area">
                <div class="logoicon">
                    <img src="{{ asset($quickShipTitle->image) ?? null }}" alt="">
                </div>
                <div class="info">
                    <h4>{{ $quickShipTitle->title_one ?? null }}</h4>
                    <p>
                        {{ $quickShipTitle->description_one ?? null }}
                    </p>
                    <div class="btn-area">
                        <a href="{{ $quickShipTitle->button_url_explore_Quick_ship ?? null }}" class="btn">Explore Quick
                            Ship</a>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="about-info-sec">
        <div class="container">
            <div class="info-1">
                <h3>{{ $quickShipTitle->title_two ?? null }}</h3>
                <p>
                    {{ $quickShipTitle->description_two ?? null }}
                </p>
            </div>
            <!--@if (!empty($services))
                <div class="info-2">
                    <div class="row" style="
    display: flex
;
    flex-direction: row;
    justify-content: center;">
                        @foreach ($services as $service)
                            <div class="col-md-3 cl-area">
                                <a href="{{ $service->link }}">
                                    <div class="box">
                                        <div class="icon">
                                            <img src="{{ asset($service->image ?? null) }}" alt="">
                                        </div>
                                        <div class="info">
                                            <h5>{{ $service->title ?? null }}</h5>
                                            <p>{{ $service->description ?? null }}</p>
                                        </div>
                                    </div>
                                </a>
                            </div>
                        @endforeach
                    </div>

                </div>
            @endif-->
        </div>
    </div>

    <!--<div class="product-main-sec">
        <div class="container">
            <div class="headarea">
                <h3> {{ $quickShipTitle->title_three ?? null }}</h3>
            </div>
            <div class="row">
                @if (!empty($colors))
                    @foreach ($colors as $color)
                        <div class="col-md-4 col-lg-3">
                            <div class="product-item">@php
                                $product = App\Models\Product::where('color_id', $color->id)->first();
                            @endphp
                                <a
                                    href="{{ route('frontend.product_details', [$color->id, $product->colorMaster_id, $product->category]) }}">
                                    <div class="product-img">
                                        <img src="{{ asset($color->image) ?? null }}" alt="">
                                    </div>
                                </a>
                                <div class="info">
                                    <h5><a
                                            href="{{ route('frontend.product_details', [$color->id, $product->colorMaster_id, $product->category]) }}">{{ $color->name ?? null }}</a>
                                    </h5>

                                    <ul class="btn-area">
                                        <li><a href="{{ route('frontend.product_details', [$color->id, $product->colorMaster_id, $product->category]) }}"
                                                class="btn">Shop Cabinet</a></li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    @endforeach
                @endif
            </div>
        </div>
    </div>

    <div class="trade-pro-sec">
        <div class="container">
            <div class="row">
                <div class="col-md-4 cl-area">
                    <h4>{{ $quickShipTitle->title_four ?? null }}</h4>
                </div>
                <div class="col-md-4 cl-area">
                    <p>{{ $quickShipTitle->title_five ?? null }}</p>
                </div>
                <div class="col-md-4 cl-area">
                    <div class="btn-area">
                        <a href="{{ $quickShipTitle->button_url_join_discount_program ?? null }}" class="btn">Join
                            Discount
                            Program</a>
                    </div>
                </div>
            </div>
        </div>
    </div>-->

    <div class="ship-form-sec">
        <div class="container">
            <div class="headarea">
                <h3>{{ $quickShipTitle->title_six ?? null }}</h3>
            </div>
            <form action="{{ route('frontend.quickShip_submit') }}" enctype="multipart/form-data" method="POST">
                @csrf
                @include('backend.common.message')
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <input type="text" class="form-control" name="name" placeholder="Name"
                                value="{{ old('name') }}">
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <input type="email" class="form-control" name="email" placeholder="Email"
                                value="{{ old('email') }}">
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <input type="text" class="form-control" name="order_no" placeholder="Order No"
                                value="{{ old('order_no') }}">
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <input type="text" class="form-control" name="zip_no" placeholder="Zip No"
                                value="{{ old('zip_no') }}">
                        </div>
                    </div>
                    <div class="col-md-12">
                        <div class="form-group">
                            <textarea id="messages" cols="3" class="form-control" name="messages">{{ old('messages') }}</textarea>
                        </div>
                    </div>
                    <div class="btn-area">
                        <button type="submit" class="btn">Join Discount Program</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
    <!-- ====== quick ship End ====== -->
@endsection
