@extends('frontend.layout.layout')
@section('meta_tag')
    <title>{{ SiteInfo::info()['site_name'] }}</title>
@endsection
@section('content')
    <!-- breadcrumb -->
    <div class="breadcrumb-sec">
        <div class="container">
            <ul>
                <li><a href="{{ route('frontend.index') }}">Home</a></li>
                <li><span>/</span></li>
                <li>Product</li>
            </ul>
        </div>
    </div>

    <!-- product main section -->
    @if (!empty($colorMasters))
        @foreach ($colorMasters as $colorMaster)
            <div class="product-section">
                <div class="container">
                    <div class="subheadline01">
                        <ul>
                            <li><span></span></li>
                            <li>
                                <h4>{{ $colorMaster->name }}</h4>
                            </li>
                        </ul>
                    </div>
                    <div class="row">
                        @if (!empty(SiteInfo::color($colorMaster->id)))
                            @foreach (SiteInfo::color($colorMaster->id) as $color)
                                <div class="col-md-4 col-lg-3">
                                    <div class="product-item">
                                        <h5>{{ $color->name }}</h5>
                                        <div class="product-img">
                                            <img src="{{ asset($color->image) }}" alt="">
                                        </div>
                                        <div class="btn-area">
                                            <a href="{{ route('frontend.product_details', [$color->id, $colorMaster->id, $colorMaster->category_id]) }}"
                                                class="btn"><span><i class="fa fa-shopping-cart" aria-hidden="true"></i>
                                                </span>Shop Now</a>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        @endif

                    </div>
                </div>
            </div>
        @endforeach
    @endif

    @push('scripts')
    @endpush
@endsection
