@extends('frontend.layout.layout')
@section('meta_tag')
    <title>{{ SiteInfo::info()['site_name'] }}</title>
@endsection
@section('content')
    <style>
        .inner_banner img {
            height: unset !important;
        }
    </style>
    <!--------- banner start --------->
    <div class="main-slider-section inner_banner design-help-sec">
        <img src="{{ asset($service->image1) }}" class="d-block w-100" alt="banner-1">
        <div class="inner_banner_info section-1">
            <div class="row align-items-center">
                <div class="col-md-6">
                    <div class="cabinet_right_txt">
                        <h2 class="cabinet_headeing">{{ $service->name }}</h2>
                        <h6>
                            {!! $service->description1 !!}
                        </h6>
                        <div>
                            <a href="#" class="btn type1"><i class="fa fa-phone" aria-hidden="true"></i> Let's Talk
                                Roswell {{ SiteInfo::info()['phone_call'] }}</a>
                        </div>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="award_winningImg">
                        <img src="{{ asset($service->image2) }}" alt="" loading="lazy">
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!--------- banner end --------->



    @if (!empty($Masters))
        <!----------- Our Services section start ---------->
        <section class="protectedBy">
            <div class="container">
                <div class="sub-headline-area">
                    <span></span>
                    <h3>{{ $service->name }}</h3>
                    <span></span>
                </div>
                <div class="row">
                    @foreach ($Masters as $Master)
                        <div class="col-lg-6">
                            <div class="protectedBy_div services_div">
                                <img src="{{ asset($Master->image2) }}" alt="" loading="lazy">
                                <h4>{{ $Master->name }}</h4>
                                <p>
                                    {{ $Master->title }}
                                </p>
                                <a href="{{ route('frontend.service', $Master->slug) }}" class="learn_more"> Learn more <i
                                        class="fa fa-long-arrow-right" aria-hidden="true"></i></a>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        </section>
        <!----------- Our Services section end ---------->
    @endif



    <!------------- best brands area start ------------->
    <div class="our_projects">
        <div class="container">
            <div class="sub-headline-area">
                <span></span>
                <h3>{{ $service->title1 }}</h3>
                <span></span>
            </div>
            <div class="owl-carousel owl-theme project_slider">
                @foreach ($brands as $brand)
                    <div class="item">
                        <a href="#" class="pic-area">
                            <img src="{{ asset($brand->image) }}" alt=""style="background: #545454;    object-fit: contain;">
                        </a>
                    </div>
                @endforeach
            </div>
        </div>
    </div>
    <!------------- best brands area end ------------->


    <!--------- free estimation start --------->
    <div class="main-slider-section inner_banner design-help-sec">
        <img src="{{ asset($service->image3) }}" class="d-block w-100" alt="banner-1">
        <div class="inner_banner_info section-1">
            <div class="row align-items-center g-5">
                <div class="col-md-5">
                    <div class="design-help-info">
                        <form action="{{ route('frontend.services_submit') }}" class="form-area" method="POST"
                            enctype="multipart/form-data">
                            @csrf
                            @include('backend.common.message')
                            <input type="hidden" value="{{ $service->id }}" name="mainId">

                            <div class="form-group">
                                <input type="text" class="form-control" name="name" placeholder="Full Name*">
                            </div>
                            <div class="form-group">
                                <input type="email" class="form-control" name="email" placeholder="Email*">
                            </div>
                            <div class="form-group">
                                <input type="number" class="form-control" name="phone" placeholder="Phone*">
                            </div>

                            <button type="submit" class="btn" width="100%">Get your FREE estimate</button>
                        </form>
                    </div>
                </div>
                @if (!empty($Masters))
                    <div class="col-md-7">
                        <div class="cabinet_right_txt">
                            <h2 class="cabinet_headeing">{{ $service->title2 }}</h2>

                            <div class="row">
                                @foreach ($Masters as $Master)
                                    <div class="col-md-3">
                                        <div class="remodelingDiv">
                                            <img src="{{ asset($Master->image2) }}" alt="" loading="lazy">
                                            <p>{{ $Master->name }}</p>
                                        </div>
                                    </div>
                                @endforeach
                            </div>
                            <p>
                                {!! $service->description2 !!}
                            </p>
                        </div>
                    </div>
                @endif
            </div>
        </div>
    </div>
    <!--------- free estimation end --------->
@endsection
