<!DOCTYPE html>
<html>
<head>
  <meta charset="UTF-8">
  <title>New Quote Request - Homes Cabinet</title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <!-- Preheader (hidden preview text) -->
  <style>
    /* iOS blue link fix */
    a[x-apple-data-detectors] { color: inherit !important; text-decoration: none !important; }
  </style>
</head>
<body style="margin:0; padding:0; background-color:#f5f7fb; font-family:Arial, Helvetica, sans-serif;">
  <!-- Wrapper -->
  <table role="presentation" width="100%" border="0" cellspacing="0" cellpadding="0">
    <tr>
      <td align="center" style="padding:24px 12px;">

        <!-- Container -->
        <table role="presentation" width="650" border="0" cellspacing="0" cellpadding="0" style="max-width:650px; background:#ffffff; border-radius:8px; overflow:hidden; box-shadow:0 6px 18px rgba(0,0,0,0.07);">

          <!-- Brand Header -->
          <tr>
            <td align="center" bgcolor="#0b3d91" style="padding:24px;">
              <a href="https://homescabinet.com" style="text-decoration:none; color:#ffffff; font-size:26px; font-weight:bold; display:inline-block;">
                Homes Cabinet
              </a>
              <div style="color:#dbe7ff; font-size:13px; margin-top:6px;">New Quote Request</div>
            </td>
          </tr>

          <!-- Title -->
          <tr>
            <td align="left" style="padding:20px 24px 0 24px; color:#111827; font-size:20px; font-weight:700;">
              Quote submission received
            </td>
          </tr>

          <!-- Intro -->
          <tr>
            <td align="left" style="padding:10px 24px 0 24px; color:#374151; font-size:14px; line-height:22px;">
              A customer submitted a new quote request on
              <a href="https://homescabinet.com" style="color:#2563eb; text-decoration:none;">homescabinet.com</a>. Details are below.
            </td>
          </tr>

          <!-- Details Table -->
          <tr>
            <td style="padding:18px 24px 8px 24px;">
              <table role="presentation" cellpadding="10" cellspacing="0" border="0" width="100%" style="border-collapse:collapse; font-size:14px; color:#111827;">
                <tr>
                  <td width="36%" style="background:#f9fafb; border:1px solid #e5e7eb; font-weight:bold;">Name</td>
                  <td style="border:1px solid #e5e7eb;">{{ $data['name'] ?? '-' }}</td>
                </tr>
                <tr>
                  <td style="background:#f9fafb; border:1px solid #e5e7eb; font-weight:bold;">Company Name</td>
                  <td style="border:1px solid #e5e7eb;">{{ $data['company_name'] ?? '-' }}</td>
                </tr>
                <tr>
                  <td style="background:#f9fafb; border:1px solid #e5e7eb; font-weight:bold;">Email</td>
                  <td style="border:1px solid #e5e7eb;">
                    <a href="mailto:{{ $data['email'] ?? '-' }}" style="color:#2563eb; text-decoration:none;">{{ $data['email'] ?? '-' }}</a>
                  </td>
                </tr>
                <tr>
                  <td style="background:#f9fafb; border:1px solid #e5e7eb; font-weight:bold;">Phone Number</td>
                  <td style="border:1px solid #e5e7eb;">
                    <a href="tel:{{ $data['phone'] ?? '-' }}" style="color:#111827; text-decoration:none;">{{ $data['phone'] ?? '-' }}</a>
                  </td>
                </tr>
                <tr>
                  <td style="background:#f9fafb; border:1px solid #e5e7eb; font-weight:bold;">Do you have measurements of your space?</td>
                  <td style="border:1px solid #e5e7eb;">{{ $data['your_space'] ?? '-' }}</td>
                </tr>
                <tr>
                  <td style="background:#f9fafb; border:1px solid #e5e7eb; font-weight:bold;">What type of project do you have?</td>
                  <td style="border:1px solid #e5e7eb;">{{ $data['project'] ?? '-' }}</td>
                </tr>
                {{--<tr>
                  <td style="background:#f9fafb; border:1px solid #e5e7eb; font-weight:bold;">Which products are you interested in?</td>
                  <td style="border:1px solid #e5e7eb;">{{ $data['interested'] ?? '-' }}</td>
                </tr>--}}
                <tr>
                  <td style="background:#f9fafb; border:1px solid #e5e7eb; font-weight:bold;">Budget Range</td>
                  <td style="border:1px solid #e5e7eb;">{{ $data['budget_range'] ?? '-' }}</td>
                </tr>
                <tr>
                  <td style="background:#f9fafb; border:1px solid #e5e7eb; font-weight:bold;">Estimated Project Timeline</td>
                  <td style="border:1px solid #e5e7eb;">{{ $data['project_timeline'] ?? '-' }}</td>
                </tr>
                <tr>
                  <td style="background:#f9fafb; border:1px solid #e5e7eb; font-weight:bold;">Showroom Visit</td>
                  <td style="border:1px solid #e5e7eb;">{{ $data['location'] ?? '-' }}</td>
                </tr>
                <tr>
                  <td style="background:#f9fafb; border:1px solid #e5e7eb; font-weight:bold;">What spaces are included in your project?</td>
                  <td style="border:1px solid #e5e7eb;">{{ $data['project_type'] ?? '-' }}</td>
                </tr>
                <tr>
                  <td style="background:#f9fafb; border:1px solid #e5e7eb; font-weight:bold;">Message</td>
                  <td style="border:1px solid #e5e7eb;">{{ $data['messages'] ?? '-' }}</td>
                </tr>
              </table>
            </td>
          </tr>

          <!-- CTA -->

          <!-- Footer -->
          <tr>
            <td align="center" bgcolor="#f3f4f6" style="padding:16px; color:#6b7280; font-size:12px;">
              © <?php echo date("Y"); ?> <a href="https://homescabinet.com" style="color:#6b7280; text-decoration:none;">homescabinet.com</a>. All rights reserved.
            </td>
          </tr>

        </table>
        <!-- /Container -->
      </td>
    </tr>
  </table>
  <!-- /Wrapper -->
</body>
</html>
