<?php

use App\Http\Controllers\Api\Auth\LoginController;
use App\Http\Controllers\Api\Auth\LogoutController;
use App\Http\Controllers\Api\Auth\ProfileController;
use App\Http\Controllers\Api\Auth\RegistrationController;
use App\Http\Controllers\Api\CommonController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::controller(LoginController::class)->group(function () {
    Route::post('/login', 'login');
});

Route::controller(RegistrationController::class)->group(function () {
    Route::post('/register', 'register');
});

Route::middleware(['auth:sanctum'])->group(function () {
    Route::controller(LogoutController::class)->group(function () {
        Route::post('/logout', 'logout');
    });

    Route::controller(ProfileController::class)->group(function () {
        Route::get('/get-profile', 'getProfile');
        Route::post('/update-profile', 'updateProfile');
        Route::post('/update-address', 'updateAddress');
        Route::post('/update-password', 'updatePassword');
        Route::post('/forgot-password', 'forgotPassword');
    });
});
