<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Backend\{
    ProfileController,
    DashboardController,
    ForgotPasswordController,
    LoginController,
    CustomerController,
    SuperadminController,
    AdminController,
    BrandsController,
    BrandsTitleController,
    CategoryController,
    CmsController,
    ContactFromController,
    CouponController,
    DesignRequestController,
    DiscountProductController,
    FaqController,
    FreeDesignContentController,
    FreeDesignServiceController,
    GeneralAssemblyController,
    GeneralAssemblyVideoController,
    GuaranteedController,
    KitchenDesignToolCotroller,
    LengthController,
    MemberController,
    MetaSeoController,
    OrderController,
    OurServicesRequestController,
    OurServisesController,
    OurServisesMainController,
    PricingContentController,
    PricingRequestController,
    PricingTitleController,
    ProMemberController,
    QuickShipRequestController,
    QuickShipTitleController,
    QuoteController,
    ServicesController,
    StaffController,
    SettingsController,
    StoreController,
    TitleHomeController,
};
use App\Http\Controllers\Backend\Master\AboutAddMorController;
use App\Http\Controllers\Backend\Master\AboutController;
use App\Http\Controllers\Backend\Master\AssemblyIsntructionsController;
use App\Http\Controllers\Backend\Master\BannerController;
use App\Http\Controllers\Backend\Master\BlogController;
use App\Http\Controllers\Backend\Master\CabinetController;
use App\Http\Controllers\Backend\Master\ColorController;
use App\Http\Controllers\Backend\Master\ColorMasterController;
use App\Http\Controllers\Backend\Master\DoorController;
use App\Http\Controllers\Backend\Master\GalleryController;
use App\Http\Controllers\Backend\Master\TypeController;
use App\Http\Controllers\Backend\Master\ProductCombinationController;
use App\Http\Controllers\Backend\Master\ProductController;
use App\Http\Controllers\Backend\Master\ProductImageController;
use App\Http\Controllers\Backend\Master\TagController;
use App\Http\Controllers\Backend\Master\YoutubeLinkController;
use App\Http\Controllers\Backend\Master\ConstructionTypeController;
use App\Http\Controllers\Backend\Master\OurServisesMasterController;
use App\Http\Controllers\Backend\Master\ProductCombinationAccController;
use App\Http\Controllers\Backend\Master\ProductCSVUplodeController;
use App\Models\OurServicesMain;

// backend login
Route::controller(LoginController::class)->group(function () {
    Route::get('login', 'login')->name('login');
    Route::post('login', 'checking_login')->name('checking.login');
    Route::get('logout', 'logout')->name('logout');
});

// forgot password
Route::controller(ForgotPasswordController::class)->group(function () {
    Route::get('forgot-password', 'forgot_password')->name('forgot_password');
});

Route::middleware(['auth', 'auth.backend'])->group(function () {
    // Route::resource('profile', ProfileController::class);
    // dashboard
    Route::controller(DashboardController::class)->group(function () {
        Route::get('dashboard', 'dashboard')->name('dashboard');
    });
    // Masters
    Route::resource('super-admin', SuperadminController::class);
    Route::post('super-admin/update-password', [SuperadminController::class, 'update_password'])->name('super-admin.update_password');
    Route::resource('customers', CustomerController::class);
    Route::resource('quote', QuoteController::class);
    Route::resource('staffs', StaffController::class);
    Route::resource('admin', AdminController::class);
    Route::resource('proMember', ProMemberController::class);
    Route::post('admin/update-password', [AdminController::class, 'update_password'])->name('admin.update_password');

    Route::resource('settings', SettingsController::class);
});
Route::prefix('master')->group(function () {

    Route::resource('banner', BannerController::class)->only([
        'index',
        'create',
        'store',
        'edit',
        'update',
        'destroy'
    ]);
    Route::resource('freeDesignContent', FreeDesignContentController::class)->only([
        'index',
        'create',
        'store',
        'edit',
        'update',
        'destroy'
    ]);
    Route::resource('freeDesignService', FreeDesignServiceController::class)->only([
        'index',
        'create',
        'store',
        'edit',
        'update',
        'destroy'
    ]);
    Route::resource('generalAssembly', GeneralAssemblyController::class)->only([
        'index',
        'create',
        'store',
        'edit',
        'update',
        'destroy'
    ]);
    Route::resource('generalAssemblyVideo', GeneralAssemblyVideoController::class)->only([
        'index',
        'create',
        'store',
        'edit',
        'update',
        'destroy'
    ]);
    Route::resource('brand', BrandsController::class)->only([
        'index',
        'create',
        'store',
        'edit',
        'update',
        'destroy'
    ]);
    Route::resource('brandsTitle', BrandsTitleController::class)->only([
        'index',
        'create',
        'store',
        'edit',
        'update',
        'destroy'
    ]);
    Route::resource('titleHome', TitleHomeController::class)->only([
        'index',
        'create',
        'store',
        'edit',
        'update',
        'destroy'
    ]);
    Route::resource('faq', FaqController::class)->only([
        'index',
        'create',
        'store',
        'edit',
        'update',
        'destroy'
    ]);
    Route::resource('category', CategoryController::class)->only([
        'index',
        'create',
        'store',
        'edit',
        'update',
        'destroy'
    ]);
    Route::resource('aboutAddMor', AboutAddMorController::class)->only([
        'index',
        'create',
        'store',
        'edit',
        'update',
        'destroy'
    ]);
    Route::resource('about', AboutController::class)->only([
        'index',
        'create',
        'store',
        'edit',
        'update'
    ]);
    Route::resource('quickShipTitle', QuickShipTitleController::class)->only([
        'index',
        'create',
        'store',
        'edit',
        'update'
    ]);
    Route::resource('member', MemberController::class)->only([
        'index',
        'create',
        'store',
        'edit',
        'update'
    ]);
    Route::resource('guaranteed', GuaranteedController::class)->only([
        'index',
        'create',
        'store',
        'edit',
        'update'
    ]);
    Route::resource('blog', BlogController::class)->only([
        'index',
        'create',
        'store',
        'edit',
        'update',
        'destroy'
    ]);
    Route::resource('store', StoreController::class)->only([
        'index',
        'create',
        'store',
        'edit',
        'update',
        'destroy'
    ]);
    Route::resource('services', ServicesController::class)->only([
        'index',
        'edit',
        'update',
    ]);
    Route::resource('customerReview', CustomerController::class)->only([
        'index',
        'create',
        'store',
        'edit',
        'update',
        'destroy'
    ]);
    Route::resource('youtubeLink', YoutubeLinkController::class)->only([
        'index',
        'create',
        'store',
        'edit',
        'update',
        'destroy'
    ]);
    Route::resource('type', TypeController::class)->only([
        'index',
        'create',
        'store',
        'edit',
        'update',
        'destroy'
    ]);
    Route::resource('ourServicesMaster', OurServisesMasterController::class)->only([
        'index',
        'create',
        'store',
        'edit',
        'update',
        'destroy'
    ]);
    Route::resource('gallery', GalleryController::class)->only([
        'index',
        'create',
        'store',
        'edit',
        'update',
        'destroy'
    ]);
    Route::resource('assemblyInstruction', AssemblyIsntructionsController::class)->only([
        'index',
        'create',
        'store',
        'edit',
        'update',
        'destroy'
    ]);
    Route::resource('pricingTitle', PricingTitleController::class)->only([
        'index',
        'create',
        'store',
        'edit',
        'update',
        'destroy'
    ]);
    Route::resource('pricingContent', PricingContentController::class)->only([
        'index',
        'create',
        'store',
        'edit',
        'update',
        'destroy'
    ]);
    Route::resource('cabinet', CabinetController::class)->only([
        'index',
        'create',
        'store',
        'edit',
        'update',
        'destroy'
    ]);
    Route::resource('tag', TagController::class)->only([
        'index',
        'create',
        'store',
        'edit',
        'update',
        'destroy'
    ]);
    Route::resource('discountProduct', DiscountProductController::class)->only([
        'index',
        'create',
        'store',
        'edit',
        'update',
        'destroy'
    ]);
    Route::resource('color', ColorController::class)->only([
        'index',
        'create',
        'store',
        'edit',
        'update',
        'destroy'
    ]);
    Route::resource('colorMaster', ColorMasterController::class)->only([
        'index',
        'create',
        'store',
        'edit',
        'update',
        'destroy'
    ]);
    Route::resource('length', LengthController::class)->only([
        'index',
        'create',
        'store',
        'edit',
        'update',
        'destroy'
    ]);
    Route::resource('door', DoorController::class)->only([
        'index',
        'create',
        'store',
        'edit',
        'update',
        'destroy'
    ]);
    Route::resource('construction', ConstructionTypeController::class)->only([
        'index',
        'create',
        'store',
        'edit',
        'update',
        'destroy'
    ]);
    Route::controller(KitchenDesignToolCotroller::class)->group(function () {
        Route::get('kitchen-design-tool/show', 'kitchen_design_tool_show')->name('kitchen.design.tool.show');
        Route::post('kitchen-design-tool/update', 'kitchen_design_tool_update')->name('kitchen.design.tool.update');
    });
});

Route::resource('product', ProductController::class)->only([
    'index',
    'create',
    'store',
    'edit',
    'update',
    'destroy'
]);

Route::resource('seo', MetaSeoController::class)->only([
    'index',
    'edit',
    'update',
]);
Route::resource('contactFrom', ContactFromController::class)->only([
    'index',
    // 'create',
    // 'store',
    // 'edit',
    // 'update',
    // 'destroy'
]);

Route::controller(ProductController::class)->group(function () {
    Route::post('all-get-colors', 'get_colors')->name('all.get.colors');
});
Route::resource('coupon', CouponController::class)->only([
    'index',
    'create',
    'store',
    'edit',
    'update',
    'destroy'
]);
Route::resource('quickShipRequest', QuickShipRequestController::class)->only([
    'index',
    'destroy'
]);
Route::resource('pricingRequest', PricingRequestController::class)->only([
    'index',
    'destroy'
]);
Route::resource('ourServicesRequest', OurServicesRequestController::class)->only([
    'index',
    'destroy'
]);
Route::controller(DiscountProductController::class)->group(function () {
    Route::post('get-master-colors', 'getMasterColors')->name('get.masterColors');
    Route::post('get-colors', 'getColors')->name('get.colors');
});
Route::controller(ProductImageController::class)->group(function () {
    Route::get('product/images/{id}', 'index')->name('productImage.index');
    Route::post('product/image-store', 'store')->name('productImage.store');
    Route::delete('product/image-delete/{id}', 'delete')->name('productImage.delete');
});
Route::controller(ProductCombinationController::class)->group(function () {
    Route::get('product/combination/{id}', 'add')->name('productCombination.add');
    Route::post('product/combination-store', 'store')->name('productCombination.store');
    Route::get('product/combination/delete/{id}', 'delete')->name('productCombination.delete');
    Route::get('product/combination/deleteAll/{id}', 'delete_all')->name('productCombination.delete_all');
    Route::post('product/combination/update', 'update')->name('productCombination.update');
    Route::post('product/combination-import', 'import')->name('productCombination.import');
    Route::get('product/combination-export', 'export')->name('productCombination.export');
});
Route::controller(ProductCombinationAccController::class)->group(function () {
    Route::get('product/combination-ass/{id}', 'add')->name('productCombinationAss.add');
    Route::post('product/combination-ass-store', 'store')->name('productCombinationAss.store');
    Route::get('product/combination-ass/delete/{id}', 'delete')->name('productCombinationAss.delete');
    Route::get('product/combination-ass/deleteAll/{id}', 'delete_all')->name('productCombinationAss.delete_all');
    Route::post('product/combination-ass/update', 'update')->name('productCombinationAss.update');
    Route::post('product/combination-ass-import', 'import')->name('productCombinationAss.import');
    Route::get('product/combination-ass-export', 'export')->name('productCombinationAss.export');
});
Route::controller(ProductCSVUplodeController::class)->group(function () {
    Route::get('product/csv-upload', 'add')->name('productCSVUplode.add');
    Route::post('product/csv-upload-import', 'import')->name('productCSVUplode.import');
    Route::get('product/csv-upload/comdication', 'add_comdication')->name('productCSVUplode.add_comdication');
    Route::post('product/csv-upload-import/comdication', 'import_comdication')->name('productCSVUplode.import_comdication');
});
Route::controller(DesignRequestController::class)->group(function () {
    Route::get('kitchen-design-request', 'kitchen_design_request')->name('kitchen.design.request');
    Route::get('kitchen-design-request/delete/{id}', 'kitchen_design_request_delete')->name('kitchen.design.request.delete');
    Route::get('free-design-request', 'free_design_request')->name('free.design.request');
    Route::get('free-design-request/delete/{id}', 'free_design_request_delete')->name('free.design.request.delete');
});
Route::resource('orders', OrderController::class);
Route::resource('cms', CmsController::class);
Route::resource('ourServicesMain', OurServisesMainController::class);

Route::resource('ourServices', OurServisesController::class)->only([
    'index',
    'create',
    'store',
    'edit',
    'update',
    'destroy'
]);
