<?php

use App\Http\Controllers\Frontend\CheckoutController;
use App\Http\Controllers\Frontend\CombinationFilterController;
use App\Http\Controllers\Frontend\Contract\ContactFromController;
use App\Http\Controllers\Frontend\OrderController;
use App\Http\Controllers\Frontend\Pages\PublicController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Frontend\Pages\AuthFrontendController;
use App\Http\Controllers\Frontend\Pages\ProductFilterController;
use App\Http\Controllers\Frontend\PricingRequestController;
use App\Http\Controllers\Frontend\QuickShipRequestController;
use App\Http\Controllers\Frontend\QuoteController;

Route::get('/', function () {
    return redirect()->route('frontend.index');
});
Route::controller(PublicController::class)->group(function () {
    Route::get('/', 'index')->name('index');
    Route::get('about-us', 'about')->name('about');
    Route::get('galleries/{id}/{type}', 'gallery')->name('gallery');
    Route::permanentRedirect('/services/kitchen-remodeling', '/services/kitchen-remodeling-atlanta-georgia');
    Route::get('services/{slug}', 'service')->name('service');
    Route::get('blogs', 'blogs')->name('blogs');
    Route::get('serviceMain', 'serviceMain')->name('serviceMain');
    Route::get('kitchen-cabinet-atlanta-georgia', 'kitchenCabinet')->name('kitchenCabinet');
    Route::get('assembly-instructions', 'assembly_isntructions')->name('assembly_isntructions');
    Route::get('blog-details/{slug}', 'blog_details')->name('blog_details');
    Route::get('contact', 'contact')->name('contact');
    Route::get('type/{id}', 'type')->name('type');
    Route::get('searchType', 'searchType')->name('searchType');
    Route::get('privacy-policy', 'privacy_policy')->name('privacy_policy');
    Route::get('product-details/{color_id}/{color_master_id}/{category_id}', 'product_details')->name('product_details');
    Route::get('refund-policy', 'refund_policy')->name('refund_policy');
    Route::get('return-policy', 'return_policy')->name('return_policy');
    Route::get('terms-and-services', 'terms_and_services')->name('terms_and_services');
    Route::get('faq', 'faq')->name('faq');
    Route::get('generalAssemblyVideo/{id}', 'generalAssemblyVideo')->name('generalAssemblyVideo');
    Route::get('design-help', 'design_help')->name('design_help');
    Route::get('kitchen-design', 'kitchen_design')->name('kitchen_design');
    Route::get('customerReviews', 'customerReviews')->name('customerReviews');
    Route::post('design-help-submit', 'design_help_submit')->name('design_help_submit');
    Route::get('thank-you-for-design-help', 'thank_you_for_design_help')->name('thank.you.for.design.help');
    Route::post('kitchen-design-submit', 'kitchen_design_submit')->name('kitchen_design_submit');
    Route::get('quick-ship', 'quick_ship')->name('quick_ship');
    Route::get('pricing', 'pricing')->name('pricing');
    Route::get('cabinate-accessories/{id}', 'cabinate_accessories')->name('cabinate_accessories');
    Route::get('cabinate-accessories-details/{id}', 'cabinate_accessories_details')->name('cabinate_accessories_details');
    Route::post('cabinate-accessories-combination', 'cabinateAccessoriesCombination')->name('cabinate.accessories.combination');
    Route::post('cabinate-accessories-filter', 'cabinateAccessoriesFilter')->name('cabinate.accessories.filter');
});
Route::controller(ContactFromController::class)->group(function () {
    Route::post('contact-submit', 'contact_submit')->name('contact_submit');
    Route::post('services-submit', 'services_submit')->name('services_submit');
    Route::get('thank-you', 'thank_you')->name('thank.you');
    Route::get('thank-you-services', 'thank_you_services')->name('thank.you.services');
    Route::post('contact-verify-submit', 'contact_verify')->name('contact_verify');
});
Route::controller(QuoteController::class)->group(function () {
    Route::get('thank-you-quote', 'thank_you_quote')->name('thank.you.quote');
    Route::post('quote-submit', 'quote_submit')->name('quote_submit');
    Route::post('quote-verify-submit', 'quote_verify')->name('quote_verify');
});
Route::controller(QuickShipRequestController::class)->group(function () {
    Route::post('quickShip-submit', 'quickShip_submit')->name('quickShip_submit');
});
Route::controller(PricingRequestController::class)->group(function () {
    Route::post('pricing-submit', 'pricing_submit')->name('pricing_submit');
});
Route::controller(ProductFilterController::class)->group(function () {
    Route::post('product-filter', 'product_filter')->name('product_filter');
});
Route::controller(CombinationFilterController::class)->group(function () {
    Route::post('filter', 'filter')->name('filter');
    Route::post('combination-filter', 'combination_filter')->name('combination_filter');
});
Route::controller(AuthFrontendController::class)->group(function () {
    Route::get('login', 'login')->name('login');
    Route::get('user-profile', 'user_profile')->name('user_profile');
    Route::post('user-profile-submit', 'user_profile_submit')->name('user_profile_submit');
    Route::get('user-address', 'user_address')->name('user_address');
    Route::post('user-address-submit', 'user_address_submit')->name('user_address_submit');
    Route::post('change-password-submit', 'change_password_submit')->name('change_password_submit');
    Route::get('change-password/{email}', 'change_password')->name('change_password');
    Route::post('forget-password-submit', 'forget_password_submit')->name('forget_password_submit');
    Route::get('forget-password', 'forget_password')->name('forget_password');
    Route::get('logout', 'logout')->name('logout');
    Route::get('signUp', 'signUp')->name('signUp');
    Route::post('signIn', 'sign_in')->name('sign_in');
    Route::get('proMember', 'proMember')->name('proMember');
    Route::post('proMember-submit', 'proMember_submit')->name('proMember_submit');
    Route::post('signUp-submit', 'sign_up_submit')->name('sign_up_submit');
    Route::get('verify-user/{id}', 'verify')->name('verify');
    Route::post('verify-submit', 'verify_submit')->name('verify_submit');
    Route::get('my-orders', 'my_orders')->name('my_orders');
    Route::get('my-order-details/{id}', 'show')->name('my_order_details');
    Route::post('get-states', 'get_states')->name('get_states');
});

Route::controller(CheckoutController::class)->group(function () {
    Route::post('cart', 'cart')->name('cart');
    Route::post('update-cart', 'update_cart')->name('update.cart');
    Route::post('remove-cart', 'remove_cart')->name('remove.cart');
    Route::post('remove-cart-all', 'remove_cart_all')->name('remove.cart.all');
    Route::get('checkout', 'checkout')->name('checkout');
    Route::get('cart-get', 'cart_get')->name('cart_get');
    Route::post('coupon-apply', 'coupon_apply')->name('coupon_apply');
});

Route::controller(OrderController::class)->group(function () {
    Route::post('order', 'order')->name('order');
    Route::get('order-success/{order_id}', 'order_success')->name('order.success');
});
